/*
 * Decompiled with CFR 0.152.
 */
package parsing.grammarParsing;

import com.sun.istack.internal.NotNull;
import constructs.Conjunction;
import constructs.WeightedPredicate;
import constructs.building.LogicSourceBuilder;
import constructs.building.factories.VariableFactory;
import constructs.example.LiftedExample;
import constructs.example.ValuedFact;
import constructs.template.components.BodyAtom;
import constructs.template.components.HeadAtom;
import constructs.template.components.WeightedRule;
import constructs.template.metadata.RuleMetadata;
import ida.ilp.logic.Term;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import networks.computation.evaluation.values.MatrixValue;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.StringValue;
import networks.computation.evaluation.values.Value;
import networks.computation.evaluation.values.VectorValue;
import networks.structure.components.weights.Weight;
import parsing.antlr.NeuralogicBaseVisitor;
import parsing.antlr.NeuralogicParser;
import parsing.grammarParsing.GrammarVisitor;
import utils.generic.Pair;

public class PlainGrammarVisitor
extends GrammarVisitor {
    private static final Logger LOG = Logger.getLogger(PlainGrammarVisitor.class.getName());

    public PlainGrammarVisitor(LogicSourceBuilder builder) {
        super(builder);
    }

    public class TemplateMetadataVisitor
    extends NeuralogicBaseVisitor<Map<String, Object>> {
        @Override
        public Map<String, Object> visitTemplateMetadata(@NotNull NeuralogicParser.TemplateMetadataContext ctx) {
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return metadata;
        }
    }

    private class MetadataListVisitor
    extends NeuralogicBaseVisitor<Map<String, Object>> {
        private MetadataListVisitor() {
        }

        @Override
        public Map<String, Object> visitMetadataList(@NotNull NeuralogicParser.MetadataListContext ctx) {
            LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
            for (NeuralogicParser.MetadataValContext paramVal : ctx.metadataVal()) {
                String parameter = paramVal.ATOMIC_NAME(0).getText();
                String valueText = null;
                if (paramVal.ATOMIC_NAME(1) != null) {
                    valueText = paramVal.ATOMIC_NAME(1).getText();
                }
                Object value = paramVal.DOLLAR() != null ? PlainGrammarVisitor.this.builder.weightFactory.construct(valueText) : (paramVal.value() != null ? (PlainGrammarVisitor)PlainGrammarVisitor.this.new WeightVisitor().parseValue((NeuralogicParser.ValueContext)paramVal.value()).s : new StringValue(valueText));
                metadata.put(parameter, value);
            }
            return metadata;
        }
    }

    public class PredicateOffsetVisitor
    extends NeuralogicBaseVisitor<Pair<WeightedPredicate, Weight>> {
        @Override
        public Pair<WeightedPredicate, Weight> visitPredicateOffset(@NotNull NeuralogicParser.PredicateOffsetContext ctx) {
            Weight offset;
            int arity = -1;
            try {
                arity = Integer.parseInt(ctx.predicate().INT().getText());
            }
            catch (Exception ex) {
                LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.predicate().ATOMIC_NAME().getText(), arity, ctx.predicate().SPECIAL() != null);
            predicate.weight = offset = ctx.weight().accept(new WeightVisitor());
            return new Pair<WeightedPredicate, Weight>(predicate, offset);
        }
    }

    public class WeightMetadataVisitor
    extends NeuralogicBaseVisitor<Pair<Weight, Map<String, Object>>> {
        @Override
        public Pair<Weight, Map<String, Object>> visitWeightMetadata(@NotNull NeuralogicParser.WeightMetadataContext ctx) {
            Weight weight = PlainGrammarVisitor.this.builder.weightFactory.construct(ctx.ATOMIC_NAME().getText());
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return new Pair<Weight, Map<String, Object>>(weight, metadata);
        }
    }

    public class PredicateMetadataVisitor
    extends NeuralogicBaseVisitor<Pair<WeightedPredicate, Map<String, Object>>> {
        @Override
        public Pair<WeightedPredicate, Map<String, Object>> visitPredicateMetadata(@NotNull NeuralogicParser.PredicateMetadataContext ctx) {
            int arity = -1;
            try {
                arity = Integer.parseInt(ctx.predicate().INT().getText());
            }
            catch (Exception ex) {
                LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.predicate().ATOMIC_NAME().getText(), arity, ctx.predicate().SPECIAL() != null);
            Map<String, Object> metadata = ctx.metadataList().accept(new MetadataListVisitor());
            return new Pair<WeightedPredicate, Map<String, Object>>(predicate, metadata);
        }
    }

    private class TermVisitor
    extends NeuralogicBaseVisitor<Term> {
        public VariableFactory variableFactory;

        private TermVisitor() {
        }

        @Override
        public Term visitTerm(@NotNull NeuralogicParser.TermContext ctx) {
            Term term;
            if (ctx.constant() != null) {
                term = PlainGrammarVisitor.this.builder.constantFactory.construct(ctx.getText());
            } else if (ctx.variable() != null) {
                term = this.variableFactory.construct(ctx.getText());
            } else {
                LOG.severe("Term is neither Constant nor Variable");
                term = null;
            }
            return term;
        }
    }

    private class WeightVisitor
    extends NeuralogicBaseVisitor<Weight> {
        private WeightVisitor() {
        }

        @Override
        public Weight visitWeight(@NotNull NeuralogicParser.WeightContext ctx) {
            Weight weight;
            Pair<Boolean, Value> value = null;
            boolean fixed = false;
            if (ctx.fixedValue() != null) {
                fixed = true;
                value = this.parseValue(ctx.fixedValue().value());
            } else if (ctx.value() != null) {
                fixed = false;
                value = this.parseValue(ctx.value());
            } else {
                LOG.severe("Weight is neither fixed nor learnable");
            }
            if (ctx.ATOMIC_NAME() != null) {
                String name = ctx.ATOMIC_NAME().getText();
                weight = PlainGrammarVisitor.this.builder.weightFactory.construct(name, (Value)value.s, fixed, (Boolean)value.r);
            } else {
                weight = PlainGrammarVisitor.this.builder.weightFactory.construct((Value)value.s, fixed, (Boolean)value.r);
            }
            return weight;
        }

        public Pair<Boolean, Value> parseValue(NeuralogicParser.ValueContext ctx) {
            Value value = null;
            boolean isInitialized = true;
            if (ctx.number() != null) {
                value = new ScalarValue(Float.parseFloat(ctx.number().getText()));
            } else if (ctx.vector() != null) {
                List<Double> vector = ctx.vector().number().stream().map(num -> Double.parseDouble(num.getText())).collect(Collectors.toList());
                value = new VectorValue(vector);
            } else if (ctx.matrix() != null) {
                ArrayList<List<Double>> vectors = new ArrayList<List<Double>>();
                for (NeuralogicParser.VectorContext vectorContext : ctx.matrix().vector()) {
                    List vector = ctx.vector().number().stream().map(num -> Double.parseDouble(num.getText())).collect(Collectors.toList());
                    vectors.add(vector);
                }
                value = new MatrixValue(vectors);
            } else if (ctx.dimensions() != null) {
                isInitialized = false;
                List dims = ctx.dimensions().number().stream().map(num -> Integer.parseInt(num.getText())).collect(Collectors.toList());
                if (dims.size() == 1) {
                    value = (Integer)dims.get(0) == 1 ? new ScalarValue() : new VectorValue((Integer)dims.get(0));
                } else if (dims.size() == 2) {
                    if ((Integer)dims.get(0) == 1) {
                        value = new VectorValue((Integer)dims.get(1));
                        ((VectorValue)value).rowOrientation = true;
                    } else if ((Integer)dims.get(1) == 1) {
                        value = new VectorValue((Integer)dims.get(0));
                        ((VectorValue)value).rowOrientation = false;
                    } else {
                        value = new MatrixValue((Integer)dims.get(0), (Integer)dims.get(1));
                    }
                }
            } else {
                LOG.severe("Value is neither number nor vector: Could not parse numeric value from " + ctx.getText());
            }
            if (value == null) {
                LOG.severe("Error during constructs.building numeric value from " + ctx.getText());
            }
            return new Pair<Boolean, Value>(isInitialized, value);
        }
    }

    private class PredicateVisitor
    extends NeuralogicBaseVisitor<WeightedPredicate> {
        int arity = -1;

        public PredicateVisitor(int arity) {
            this.arity = arity;
        }

        @Override
        public WeightedPredicate visitPredicate(@NotNull NeuralogicParser.PredicateContext ctx) {
            if (ctx.INT() != null) {
                try {
                    this.arity = Integer.parseInt(ctx.INT().getText());
                }
                catch (Exception ex) {
                    LOG.severe("Cannot parse arity of a predicate from " + ctx.getText());
                }
            }
            WeightedPredicate predicate = PlainGrammarVisitor.this.builder.predicateFactory.construct(ctx.ATOMIC_NAME().getText(), this.arity, ctx.SPECIAL() != null);
            return predicate;
        }
    }

    public class FactVisitor
    extends NeuralogicBaseVisitor<ValuedFact> {
        public VariableFactory variableFactory = new VariableFactory();

        @Override
        public ValuedFact visitFact(@NotNull NeuralogicParser.FactContext ctx) {
            return this.visitAtom(ctx.atom());
        }

        @Override
        public ValuedFact visitAtom(@NotNull NeuralogicParser.AtomContext ctx) {
            TermVisitor termVisitor = new TermVisitor();
            termVisitor.variableFactory = this.variableFactory;
            List<Object> terms = ctx.termList() != null ? ctx.termList().term().stream().map(term -> term.accept(termVisitor)).collect(Collectors.toList()) : new ArrayList(0);
            WeightedPredicate predicate = ctx.predicate().accept(new PredicateVisitor(terms.size()));
            Weight weight = null;
            if (ctx.weight() != null) {
                weight = ctx.weight().accept(new WeightVisitor());
            }
            ValuedFact fact = new ValuedFact(predicate, terms, ctx.negation() != null, weight);
            fact.originalString = ctx.getText();
            return fact;
        }
    }

    public class FactConjunctionVisitor
    extends NeuralogicBaseVisitor<Conjunction> {
        public VariableFactory variableFactory;

        @Override
        public Conjunction visitConjunction(@NotNull NeuralogicParser.ConjunctionContext ctx) {
            FactVisitor factVisitor = new FactVisitor();
            factVisitor.variableFactory = this.variableFactory;
            List<ValuedFact> conjunction = ctx.atom().stream().map(atom -> atom.accept(factVisitor)).collect(Collectors.toList());
            return new Conjunction(conjunction);
        }
    }

    public class LabelVisitor
    extends NeuralogicBaseVisitor<Conjunction> {
        public VariableFactory variableFactory;

        @Override
        public Conjunction visitLabel(NeuralogicParser.LabelContext ctx) {
            FactConjunctionVisitor factConjunctionVisitor = new FactConjunctionVisitor();
            Conjunction label = ctx.conjunction().accept(factConjunctionVisitor);
            return label;
        }
    }

    public class LiftedExampleVisitor
    extends NeuralogicBaseVisitor<LiftedExample> {
        VariableFactory variableFactory = new VariableFactory();

        @Override
        public LiftedExample visitLiftedExample(@NotNull NeuralogicParser.LiftedExampleContext ctx) {
            FactConjunctionVisitor factConjunctionVisitor = new FactConjunctionVisitor();
            factConjunctionVisitor.variableFactory = this.variableFactory;
            RuleLineVisitor ruleLineVisitor = new RuleLineVisitor();
            ruleLineVisitor.variableFactory = this.variableFactory;
            List<Conjunction> conjunctions = ctx.conjunction().stream().map(conj -> conj.accept(factConjunctionVisitor)).collect(Collectors.toList());
            List<WeightedRule> rules = ctx.lrnnRule().stream().map(conj -> conj.accept(ruleLineVisitor)).collect(Collectors.toList());
            LiftedExample liftedExample = new LiftedExample(conjunctions, rules);
            LOG.info("Example extracted: " + liftedExample);
            return liftedExample;
        }
    }

    public class AtomVisitor
    extends NeuralogicBaseVisitor<BodyAtom> {
        VariableFactory variableFactory;

        @Override
        public BodyAtom visitAtom(@NotNull NeuralogicParser.AtomContext ctx) {
            TermVisitor termVisitor = new TermVisitor();
            termVisitor.variableFactory = this.variableFactory;
            List<Object> terms = ctx.termList() != null ? ctx.termList().term().stream().map(term -> term.accept(termVisitor)).collect(Collectors.toList()) : new ArrayList(0);
            WeightedPredicate predicate = ctx.predicate().accept(new PredicateVisitor(terms.size()));
            Weight weight = ctx.weight() != null ? ctx.weight().accept(new WeightVisitor()) : null;
            BodyAtom bodyAtom = new BodyAtom(predicate, terms, ctx.negation() != null, weight);
            bodyAtom.originalString = ctx.getText();
            return bodyAtom;
        }
    }

    public class AtomConjunctionVisitor
    extends NeuralogicBaseVisitor<List<BodyAtom>> {
        VariableFactory variableFactory;

        @Override
        public List<BodyAtom> visitConjunction(@NotNull NeuralogicParser.ConjunctionContext ctx) {
            AtomVisitor atomVisitor = new AtomVisitor();
            atomVisitor.variableFactory = this.variableFactory;
            List<BodyAtom> atomList = ctx.atom().stream().map(atom -> atom.accept(atomVisitor)).collect(Collectors.toList());
            return atomList;
        }
    }

    public class RuleLineVisitor
    extends NeuralogicBaseVisitor<WeightedRule> {
        VariableFactory variableFactory;

        @Override
        public WeightedRule visitLrnnRule(@NotNull NeuralogicParser.LrnnRuleContext ctx) {
            this.variableFactory = new VariableFactory();
            WeightedRule rule = new WeightedRule();
            rule.setOriginalString(ctx.getText());
            AtomVisitor headVisitor = new AtomVisitor();
            headVisitor.variableFactory = this.variableFactory;
            BodyAtom headAtom = ctx.atom().accept(headVisitor);
            Weight weight = headAtom.getConjunctWeight();
            if (weight == null) {
                rule.setWeight(Weight.unitWeight);
            } else {
                rule.setWeight(weight);
            }
            rule.setHead(new HeadAtom(headAtom));
            AtomConjunctionVisitor bodyVisitor = new AtomConjunctionVisitor();
            bodyVisitor.variableFactory = this.variableFactory;
            rule.setBody(ctx.conjunction().accept(bodyVisitor));
            Weight offset = null;
            if (ctx.offset() != null) {
                offset = ctx.offset().accept(new WeightVisitor());
            } else if (PlainGrammarVisitor.this.builder.settings.ruleAdaptiveOffset) {
                offset = PlainGrammarVisitor.this.builder.settings.defaultRuleOffsetsLearnable ? PlainGrammarVisitor.this.builder.weightFactory.construct(new ScalarValue(-rule.getBody().size()), false, true) : PlainGrammarVisitor.this.builder.weightFactory.construct(new ScalarValue(-rule.getBody().size()), true, true);
            }
            rule.setOffset(offset);
            rule.setMetadata(ctx.metadataList() != null ? new RuleMetadata(PlainGrammarVisitor.this.builder.settings, ctx.metadataList().accept(new MetadataListVisitor())) : null);
            return rule;
        }
    }
}

