/*
 * Decompiled with CFR 0.152.
 */
package parsing.queries;

import constructs.Conjunction;
import constructs.building.factories.VariableFactory;
import constructs.example.ValuedFact;
import java.util.logging.Logger;
import java.util.stream.Stream;
import parsing.antlr.NeuralogicParser;
import parsing.grammarParsing.PlainGrammarVisitor;
import parsing.queries.QueriesParseTreeExtractor;
import utils.Utilities;
import utils.generic.Pair;

public class PlainQueriesParseTreeExtractor
extends QueriesParseTreeExtractor<PlainGrammarVisitor> {
    private static final Logger LOG = Logger.getLogger(PlainQueriesParseTreeExtractor.class.getName());

    public PlainQueriesParseTreeExtractor(PlainGrammarVisitor v) {
        super(v);
    }

    @Override
    public Stream<Conjunction> getQueries(NeuralogicParser.QueriesFileContext ctx) {
        PlainGrammarVisitor.FactConjunctionVisitor factConjunctionVisitor = new PlainGrammarVisitor.FactConjunctionVisitor((PlainGrammarVisitor)this.visitor);
        if (ctx.conjunction() != null) {
            Stream<Conjunction> labelStream = ctx.conjunction().stream().map(line -> line.accept(factConjunctionVisitor));
            return labelStream;
        }
        LOG.severe("Could not extract any queries");
        return null;
    }

    @Override
    public Stream<Pair<ValuedFact, Conjunction>> getLabeledQueries(NeuralogicParser.QueriesFileContext ctx) {
        VariableFactory variableFactory = new VariableFactory();
        PlainGrammarVisitor.FactVisitor factVisitor = new PlainGrammarVisitor.FactVisitor((PlainGrammarVisitor)this.visitor);
        factVisitor.variableFactory = variableFactory;
        PlainGrammarVisitor.FactConjunctionVisitor factConjunctionVisitor = new PlainGrammarVisitor.FactConjunctionVisitor((PlainGrammarVisitor)this.visitor);
        factConjunctionVisitor.variableFactory = variableFactory;
        if (ctx.conjunction() != null) {
            Stream<Conjunction> queriesStream = ctx.conjunction().stream().map(line -> line.accept(factConjunctionVisitor));
            if (ctx.atom() != null && ctx.atom().size() > 0) {
                Stream<ValuedFact> labelStream = ctx.atom().stream().map(atom -> atom.accept(factVisitor));
                return Utilities.zipStreams(labelStream, queriesStream, (lab, query) -> new Pair<ValuedFact, Conjunction>((ValuedFact)lab, (Conjunction)query));
            }
            return queriesStream.map(q -> new Pair<Object, Conjunction>(null, (Conjunction)q));
        }
        LOG.severe("Could not extract any queries");
        return null;
    }
}

