/*
 * Decompiled with CFR 0.152.
 */
package pipelines;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import pipelines.Block;
import pipelines.ConnectAfter;
import pipelines.ConnectBefore;
import settings.Settings;
import utils.exporting.Exporter;

public abstract class Pipe<I, O>
extends Block
implements Function<I, O>,
ConnectBefore<I>,
ConnectAfter<O> {
    private static final Logger LOG = Logger.getLogger(Pipe.class.getName());
    O outputReady;
    public ConnectAfter<I> input;
    public ConnectBefore<O> output;

    protected Pipe(String id) {
        this(id, null);
    }

    protected Pipe(String id, Settings settings) {
        this.settings = settings;
        this.ID = id;
        this.exporter = Exporter.getFrom(id, settings);
    }

    @Override
    public void accept(I input) {
        LOG.finer("Entering: " + this.ID);
        this.outputReady = this.apply(input);
        this.export(this.outputReady);
        if (this.output != null) {
            this.output.accept(this.outputReady);
        }
    }

    @Override
    public O get() {
        if (this.outputReady == null) {
            LOG.finer("Backtracking pipe " + this.ID);
        }
        return this.outputReady;
    }

    private void prepend(ConnectAfter<I> pipe) {
        this.input = pipe;
    }

    public void append(ConnectBefore<O> pipe) {
        this.output = pipe;
    }

    public void insertBefore(Pipe<?, I> before, Pipe<I, I> insert) {
        before.output = insert;
        insert.input = before;
        this.input = insert;
        insert.output = this;
    }

    public void insertAfter(Pipe<O, ?> after, Pipe<O, O> insert) {
        after.input = insert;
        insert.output = after;
        this.output = insert;
        insert.input = this;
    }

    @Override
    public ConnectBefore<O> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(ConnectBefore<O> prev) {
        this.output = prev;
    }

    @Override
    public ConnectAfter<I> getInput() {
        return this.input;
    }

    @Override
    public void setInput(ConnectAfter<I> prev) {
        this.input = prev;
    }

    @Deprecated
    public List<Pipe<I, O>> multiple(int count) {
        ArrayList<Pipe<I, O>> copies = new ArrayList<Pipe<I, O>>(count);
        for (int i = 0; i < count; ++i) {
            try {
                Pipe clone = (Pipe)this.getClass().getDeclaredConstructor(String.class).newInstance(this.ID + i);
                copies.add(clone);
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (!copies.isEmpty()) {
            return copies;
        }
        LOG.severe("Cloning of a pipe:" + this.ID + " was not succesfull!");
        return null;
    }

    public List<Pipe<I, O>> parallel(int count) {
        ArrayList<Pipe<I, O>> copies = new ArrayList<Pipe<I, O>>(count);
        for (int i = 0; i < count; ++i) {
            Pipe pipe = new Pipe<I, O>(this.ID + i){

                @Override
                public O apply(I i) {
                    return Pipe.this.apply(i);
                }
            };
        }
        return copies;
    }

    public static <T, A extends ConnectAfter<T>, B extends ConnectBefore<T>> void connect(List<A> prev, List<B> next) {
        if (prev.size() != next.size()) {
            LOG.severe("The 2 Lists of pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < prev.size(); ++i) {
            ((ConnectAfter)prev.get(i)).connectAfter((ConnectBefore)next.get(i));
        }
    }
}

