/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.building.factories.WeightFactory;
import constructs.example.LogicSample;
import constructs.template.Template;
import grounding.Grounder;
import grounding.GroundingSample;
import grounding.debugging.GroundingDebugger;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.pipes.generic.StreamParallelizationPipe;
import pipelines.pipes.specific.GlobalSharingGroundingPipe;
import pipelines.pipes.specific.GroundingSampleWrappingPipe;
import pipelines.pipes.specific.SequentiallySharedGroundingPipe;
import pipelines.pipes.specific.StandardGroundingPipe;
import pipelines.pipes.specific.SupervisedGroundTemplatePruning;
import pipelines.pipes.specific.SupervisedTemplateReducingPipe;
import settings.Settings;
import utils.generic.Pair;

public class GroundingBuilder
extends AbstractPipelineBuilder<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> {
    private static final Logger LOG = Logger.getLogger(GroundingBuilder.class.getName());
    Grounder grounder;

    public GroundingBuilder(Settings settings) {
        super(settings);
        this.grounder = Grounder.getGrounder(settings);
    }

    public GroundingBuilder(Settings settings, WeightFactory weightFactory) {
        super(settings);
        this.grounder = Grounder.getGrounder(settings);
        this.grounder.weightFactory = weightFactory;
    }

    @Override
    public Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> buildPipeline() {
        Pipe groundingPipe;
        Pipe nextPipe;
        Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> pipeline = new Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>>("GroundingPipeline", this);
        GroundingSampleWrappingPipe groundingSamples = pipeline.registerStart(new GroundingSampleWrappingPipe(this.settings));
        if (this.settings.parallelGrounding) {
            StreamParallelizationPipe parallelPipe = pipeline.register(new StreamParallelizationPipe());
            groundingSamples.connectAfter(parallelPipe);
            nextPipe = parallelPipe;
        } else {
            nextPipe = groundingSamples;
        }
        if (this.settings.supervisedTemplateGraphPruning) {
            SupervisedTemplateReducingPipe templateReducing = pipeline.register(new SupervisedTemplateReducingPipe());
            nextPipe.connectAfter(templateReducing);
            nextPipe = templateReducing;
        }
        if (this.settings.groundingMode == Settings.GroundingMode.SEQUENTIAL) {
            groundingPipe = pipeline.registerEnd(new SequentiallySharedGroundingPipe(this.grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        } else if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL) {
            groundingPipe = pipeline.registerEnd(new GlobalSharingGroundingPipe(this.grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        } else {
            groundingPipe = pipeline.registerEnd(new StandardGroundingPipe(this.grounder));
            nextPipe.connectAfter(groundingPipe);
            nextPipe = groundingPipe;
        }
        if (this.settings.explicitSupervisedGroundTemplatePruning) {
            SupervisedGroundTemplatePruning groundReducingPipe = pipeline.registerEnd(new SupervisedGroundTemplatePruning());
            nextPipe.connectAfter(groundReducingPipe);
            nextPipe = groundReducingPipe;
        }
        if (this.settings.debugGrounding) {
            new GroundingDebugger(this.settings).addDebugStream(pipeline);
        }
        return pipeline;
    }
}

