/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import grounding.GroundTemplate;
import grounding.GroundingSample;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.training.NeuralSample;
import networks.structure.building.NeuralProcessingSample;
import networks.structure.building.Neuralizer;
import networks.structure.building.debugging.NeuralDebugger;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.DetailedNetwork;
import pipelines.Block;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.pipes.generic.IdentityGenPipe;
import pipelines.pipes.specific.CompressionPipe;
import pipelines.pipes.specific.CycleBreakingPipe;
import pipelines.pipes.specific.EdgeMergerPipe;
import pipelines.pipes.specific.NetworkFinalizationPipe;
import pipelines.pipes.specific.PruningPipe;
import settings.Settings;
import utils.Utilities;

public class NeuralNetsBuilder
extends AbstractPipelineBuilder<Stream<GroundingSample>, Stream<NeuralSample>> {
    private static final Logger LOG = Logger.getLogger(NeuralNetsBuilder.class.getName());
    Neuralizer neuralizer;

    public NeuralNetsBuilder(Settings settings) {
        super(settings);
    }

    public NeuralNetsBuilder(Settings settings, Neuralizer neuralizer) {
        super(settings);
        this.neuralizer = neuralizer;
    }

    @Override
    public Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> buildPipeline() {
        Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> pipeline = new Pipeline<Stream<GroundingSample>, Stream<NeuralSample>>("NeuralNetsCreationPipeline", this);
        Block nextPipe = null;
        nextPipe = pipeline.registerStart(new Pipe<Stream<GroundingSample>, Stream<NeuralProcessingSample>>("GlobalSupervisedNeuralizationPipe", this.settings){

            @Override
            public Stream<NeuralProcessingSample> apply(Stream<GroundingSample> groundingSampleStream) {
                if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL) {
                    List<GroundingSample> groundingSamples = Utilities.terminateSampleStream(groundingSampleStream);
                    GroundTemplate groundTemplate = groundingSamples.get((int)0).groundingWrap.getGroundTemplate();
                    LOG.info("Neuralizing GLOBAL sample " + groundTemplate.toString());
                    List<NeuralProcessingSample> neuralizedSamples = NeuralNetsBuilder.this.neuralizer.neuralize(groundTemplate, groundingSamples);
                    DetailedNetwork detailedNetwork = neuralizedSamples.get((int)0).detailedNetwork;
                    LOG.info("GLOBAL NeuralNet created: " + detailedNetwork.toString());
                    return neuralizedSamples.stream();
                }
                return groundingSampleStream.peek(s -> LOG.info("Neuralizing sample " + s.toString())).map(sample -> NeuralNetsBuilder.this.neuralizer.neuralize((GroundingSample)sample).stream()).flatMap(f -> f).peek(s -> LOG.info("NeuralNet created: " + s.toString()));
            }
        });
        if (this.settings.neuralNetsPostProcessing) {
            Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> postprocessingPipeline = pipeline.register(this.buildProcessingPipeline());
            nextPipe.connectAfter(postprocessingPipeline);
            nextPipe = postprocessingPipeline;
        } else {
            LOG.warning("Skipping all neural optimization steps!");
        }
        NetworkFinalizationPipe finalizationPipe = pipeline.register(new NetworkFinalizationPipe(this.settings, this.neuralizer.neuralNetBuilder));
        nextPipe.connectAfter(finalizationPipe);
        2 cutoffPipe = pipeline.registerEnd(new Pipe<Stream<NeuralProcessingSample>, Stream<NeuralSample>>("ReleaseMemoryPipe", this.settings){

            @Override
            public Stream<NeuralSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
                return neuralProcessingSampleStream.map(s -> {
                    ((QueryNeuron)s.query).evidence = NeuralNetsBuilder.this.neuralizer.neuralNetBuilder.neuralBuilder.networkFactory.extractOptimizedNetwork(s.detailedNetwork);
                    if (this.settings.groundingMode != Settings.GroundingMode.GLOBAL) {
                        Utilities.logMemory();
                    }
                    return new NeuralSample(s.target, (QueryNeuron)s.query);
                });
            }
        });
        finalizationPipe.connectAfter(cutoffPipe);
        if (this.settings.debugNeuralization) {
            new NeuralDebugger(this.settings).addDebugStream(pipeline);
        }
        return pipeline;
    }

    public Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> buildProcessingPipeline() {
        Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> pipeline = new Pipeline<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>>("NeuralNetsPostprocessingPipeline", this.settings);
        Pipe nextPipe = pipeline.registerStart(new IdentityGenPipe("NNBuildingInit"));
        if (this.settings.neuralNetsSupervisedPruning) {
            // empty if block
        }
        if (this.settings.copyOutInputOvermapping) {
            // empty if block
        }
        if (this.settings.chainPruning) {
            PruningPipe pruningPipe = pipeline.registerEnd(new PruningPipe(this.settings));
            nextPipe.connectAfter(pruningPipe);
            nextPipe = pruningPipe;
        }
        if (this.settings.isoValueCompression) {
            CompressionPipe isoValuePipe = pipeline.registerEnd(new CompressionPipe(this.settings));
            nextPipe.connectAfter(isoValuePipe);
            nextPipe = isoValuePipe;
        }
        if (this.settings.isoGradientCompression) {
            // empty if block
        }
        if (this.settings.mergeIdenticalWeightedInputs || this.settings.removeIdenticalUnweightedInputs) {
            EdgeMergerPipe edgeMergerPipe = pipeline.registerEnd(new EdgeMergerPipe(this.settings));
            nextPipe.connectAfter(edgeMergerPipe);
            nextPipe = edgeMergerPipe;
        }
        if (this.settings.cycleBreaking) {
            CycleBreakingPipe pipe = pipeline.registerEnd(new CycleBreakingPipe(this.settings));
            nextPipe.connectAfter(pipe);
            nextPipe = pipe;
        }
        if (this.settings.collapseWeights) {
            // empty if block
        }
        if (this.settings.expandEmbeddings) {
            // empty if block
        }
        return pipeline;
    }
}

