/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.building.TemplateBuilder;
import constructs.building.debugging.TemplateDebugger;
import constructs.template.Template;
import constructs.template.transforming.MetadataProcessor;
import constructs.template.transforming.TemplateReducing;
import constructs.template.types.GraphTemplate;
import constructs.template.types.ParsedTemplate;
import java.util.logging.Logger;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import settings.Settings;
import settings.Sources;

public class TemplateProcessingBuilder
extends AbstractPipelineBuilder<Sources, Template> {
    private static final Logger LOG = Logger.getLogger(TemplateProcessingBuilder.class.getName());
    private final Sources sources;
    TemplateBuilder templateBuilder;
    MetadataProcessor metadataProcessor;
    TemplateReducing templateReducer;

    public TemplateProcessingBuilder(Settings settings, Sources sources) {
        super(settings);
        this.templateBuilder = new TemplateBuilder(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Template> buildPipeline() {
        Pipeline<Sources, Template> pipeline = new Pipeline<Sources, Template>("TemplateProcessingPipeline", this);
        if (this.sources.templateProvided) {
            1 nextPipe;
            Pipe<Sources, ParsedTemplate> sourcesTemplatePipe = pipeline.registerStart(this.extractTemplate(this.sources));
            if (this.settings.processMetadata) {
                nextPipe = pipeline.registerEnd(this.processMetadata());
                sourcesTemplatePipe.connectAfter(nextPipe);
            } else {
                nextPipe = pipeline.registerEnd(new Pipe<ParsedTemplate, Template>("SkippingMetadataPipe"){

                    @Override
                    public Template apply(ParsedTemplate parsedTemplate) {
                        return parsedTemplate;
                    }
                });
                sourcesTemplatePipe.connectAfter(nextPipe);
            }
            Pipe<Template, Template> nextPipe1 = null;
            if (this.settings.reduceTemplate) {
                Pipe<Template, GraphTemplate> graphTemplatePipe = pipeline.register(this.buildTemplateGraph());
                nextPipe.connectAfter(graphTemplatePipe);
                Pipe<GraphTemplate, Template> reduceTemplatePipe = this.reduceTemplate();
                graphTemplatePipe.connectAfter(pipeline.registerEnd(reduceTemplatePipe));
                nextPipe1 = reduceTemplatePipe;
            }
            if (this.settings.inferTemplateFacts) {
                Pipe<Template, Template> inferencePipe = pipeline.registerEnd(this.inferFacts());
                nextPipe1.connectAfter(inferencePipe);
                nextPipe1 = inferencePipe;
            }
            if (this.settings.debugTemplate) {
                new TemplateDebugger(this.settings).addDebugElement(pipeline);
            }
            return pipeline;
        }
        LOG.warning("Template extraction from sources requested but no template provided.");
        return null;
    }

    protected Pipe<Template, Template> inferFacts() {
        return new Pipe<Template, Template>("TemplateInferencePipe"){

            @Override
            public Template apply(Template template) {
                template.inferTemplateFacts();
                return template;
            }
        };
    }

    protected Pipe<GraphTemplate, Template> reduceTemplate() {
        this.templateReducer = TemplateReducing.getReducer(this.settings);
        return new Pipe<GraphTemplate, Template>("TemplateReducingPipe"){

            @Override
            public Template apply(GraphTemplate template) {
                return TemplateProcessingBuilder.this.templateReducer.reduce(template);
            }
        };
    }

    protected Pipe<ParsedTemplate, Template> processMetadata() {
        this.metadataProcessor = new MetadataProcessor(this.settings);
        return new Pipe<ParsedTemplate, Template>("MetadataProcessingPipe"){

            @Override
            public Template apply(ParsedTemplate template) {
                return TemplateProcessingBuilder.this.metadataProcessor.processMetadata(template);
            }
        };
    }

    public Pipe<Sources, ParsedTemplate> extractTemplate(Sources sources) {
        if (!sources.templateProvided) {
            LOG.severe("No template provided yet required.");
            return null;
        }
        Pipe<Sources, ParsedTemplate> pipe = new Pipe<Sources, ParsedTemplate>("TemplateExtractionPipe"){

            @Override
            public ParsedTemplate apply(Sources sources) {
                return TemplateProcessingBuilder.this.templateBuilder.buildTemplateFrom(sources.templateReader);
            }
        };
        return pipe;
    }

    protected Pipe<Template, GraphTemplate> buildTemplateGraph() {
        return new Pipe<Template, GraphTemplate>("BuildTemplateGraphPipe"){

            @Override
            public GraphTemplate apply(Template template) {
                GraphTemplate graphTemplate = new GraphTemplate(template);
                return graphTemplate;
            }
        };
    }
}

