/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import networks.structure.building.NeuralProcessingSample;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.metadata.states.State;
import networks.structure.transforming.NetworkReducing;
import pipelines.Pipe;
import settings.Settings;
import utils.Utilities;

public class CompressionPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(CompressionPipe.class.getName());
    NetworkReducing compressor;

    public CompressionPipe(Settings settings) {
        super("CompressionPipe", settings);
        this.compressor = NetworkReducing.getCompressor(settings);
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL) {
            List<NeuralProcessingSample> neuralProcessingSamples = Utilities.terminateSampleStream(neuralProcessingSampleStream);
            DetailedNetwork detailedNetwork = neuralProcessingSamples.get((int)0).detailedNetwork;
            List<QueryNeuron> queryNeurons = neuralProcessingSamples.stream().map(s -> (QueryNeuron)s.query).collect(Collectors.toList());
            NeuralNetwork reducedNetwork = this.compressor.reduce((DetailedNetwork<State.Structure>)detailedNetwork, queryNeurons);
            this.trueExport();
            return neuralProcessingSamples.stream().map(s -> {
                ((QueryNeuron)s.query).evidence = reducedNetwork;
                return s;
            });
        }
        if (this.exporter != null) {
            neuralProcessingSampleStream.onClose(() -> this.trueExport());
        }
        return neuralProcessingSampleStream.map(sample -> {
            if (!sample.detailedNetwork.compressed) {
                ((QueryNeuron)sample.query).evidence = this.compressor.reduce((DetailedNetwork<State.Structure>)sample.detailedNetwork, (QueryNeuron)sample.query);
                sample.detailedNetwork.compressed = true;
            }
            return sample;
        });
    }

    @Override
    protected <T> void export(T outputReady) {
    }

    protected void trueExport() {
        if (this.exporter != null) {
            this.compressor.finish();
            this.exporter.export(this.compressor);
        }
    }
}

