/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.structure.building.NeuralProcessingSample;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.transforming.CycleBreaking;
import pipelines.Pipe;
import settings.Settings;

public class CycleBreakingPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(CycleBreakingPipe.class.getName());
    CycleBreaking breaker;

    public CycleBreakingPipe(Settings settings) {
        super("CycleBreakingPipe");
        this.breaker = CycleBreaking.getBreaker(settings);
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        return neuralProcessingSampleStream.map(net -> {
            ((QueryNeuron)net.query).evidence = this.breaker.breakCycles((NeuralNetwork)((QueryNeuron)net.query).evidence);
            return net;
        });
    }
}

