/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.structure.building.NeuralProcessingSample;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.metadata.states.State;
import networks.structure.transforming.NetworkReducing;
import pipelines.Pipe;
import settings.Settings;

public class EdgeMergerPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(EdgeMergerPipe.class.getName());
    private final Settings settings;
    NetworkReducing merger;

    public EdgeMergerPipe(Settings settings) {
        super("EdgeMergerPipe");
        this.settings = settings;
        this.merger = NetworkReducing.getEdgeMerger(settings);
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        return neuralProcessingSampleStream.map(net -> {
            ((QueryNeuron)net.query).evidence = this.merger.reduce((DetailedNetwork<State.Structure>)net.detailedNetwork, (QueryNeuron)net.query);
            return net;
        });
    }
}

