/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import constructs.example.LiftedExample;
import constructs.example.LogicSample;
import constructs.example.QueryAtom;
import constructs.template.Template;
import grounding.GroundingSample;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipe;
import settings.Settings;
import utils.generic.Pair;

public class GroundingSampleWrappingPipe
extends Pipe<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> {
    private static final Logger LOG = Logger.getLogger(GroundingSampleWrappingPipe.class.getName());
    private final Settings settings;

    public GroundingSampleWrappingPipe(Settings settings) {
        super("GroundingSampleWrappingPipe");
        this.settings = settings;
    }

    @Override
    public Stream<GroundingSample> apply(Pair<Template, Stream<LogicSample>> templateStreamPair) {
        if (((Stream)templateStreamPair.s).isParallel()) {
            LOG.warning("Samples come in parallel into grounder already, this may have negative effect on shared grounding.");
            if (!this.settings.oneQueryPerExample) {
                templateStreamPair.s = ((Stream)templateStreamPair.s).sequential();
            }
        }
        GroundingSample.Wrap lastGroundingWrap = new GroundingSample.Wrap(null);
        Stream<GroundingSample> groundingSampleStream = ((Stream)templateStreamPair.s).map(sample -> {
            if (((QueryAtom)sample.query).evidence == null) {
                LOG.severe("Query-Example mismatch: No example evidence was matched for this query: #" + ((QueryAtom)sample.query).position + ":" + sample.query);
            }
            GroundingSample groundingSample = new GroundingSample((LogicSample)sample, (Template)templateStreamPair.r);
            if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL || this.settings.groundingMode == Settings.GroundingMode.SEQUENTIAL) {
                groundingSample.groundingWrap = lastGroundingWrap;
            }
            if (((LiftedExample)((QueryAtom)sample.query).evidence).equals(lastGroundingWrap.getExample())) {
                groundingSample.groundingComplete = true;
            } else {
                lastGroundingWrap.setExample((LiftedExample)((QueryAtom)sample.query).evidence);
                groundingSample.groundingComplete = false;
            }
            return groundingSample;
        });
        return groundingSampleStream;
    }
}

