/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import networks.structure.building.NeuralProcessingSample;
import networks.structure.building.builders.NeuralNetBuilder;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.metadata.states.State;
import networks.structure.transforming.NetworkReducing;
import networks.structure.transforming.ParentsExtractor;
import pipelines.Pipe;
import settings.Settings;

public class NetworkFinalizationPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(NetworkFinalizationPipe.class.getName());
    private final NeuralNetBuilder neuralNetBuilder;

    public NetworkFinalizationPipe(Settings settings, NeuralNetBuilder neuralNetBuilder) {
        super("NetworksFinalizationPipe", settings);
        this.neuralNetBuilder = neuralNetBuilder;
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL && this.settings.iterationMode == Settings.IterationMode.TOPOLOGIC) {
            neuralProcessingSampleStream = neuralProcessingSampleStream.map(sample -> {
                DetailedNetwork emptyCopy = sample.detailedNetwork.emptyCopy(sample.getId());
                NetworkReducing.supervisedNetReconstruction((DetailedNetwork<State.Structure>)emptyCopy, (BaseNeuron)((Object)((QueryNeuron)sample.query).neuron));
                sample.detailedNetwork = emptyCopy;
                ((QueryNeuron)sample.query).evidence = emptyCopy;
                return sample;
            });
        }
        if (this.settings.parentCounting && (this.settings.parallelTraining || !this.settings.neuralStreaming)) {
            ParentsExtractor parentsExtractor = new ParentsExtractor();
            List<NeuralProcessingSample> processingSamples = neuralProcessingSampleStream.collect(Collectors.toList());
            processingSamples.forEach(sample -> parentsExtractor.extractSharedNeuronsParents(sample.detailedNetwork));
            neuralProcessingSampleStream = processingSamples.stream();
        }
        return neuralProcessingSampleStream.map(sample -> {
            sample.detailedNetwork = this.neuralNetBuilder.neuralBuilder.statesBuilder.setupFinalStatesCache(sample.detailedNetwork);
            return sample;
        });
    }
}

