/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import networks.structure.export.NeuralSerializer;
import pipelines.Pipe;
import utils.generic.Pair;

public class NeuralSerializerPipe
extends Pipe<Pair<NeuralModel, Stream<NeuralSample>>, Pair<List<NeuralSerializer.SerializedWeight>, Stream<NeuralSerializer.SerializedSample>>> {
    private static final Logger LOG = Logger.getLogger(NeuralSerializerPipe.class.getName());
    NeuralSerializer neuralSerializer = new NeuralSerializer();

    public NeuralSerializerPipe() {
        super("NetworkSerializerPipe");
    }

    @Override
    public Pair<List<NeuralSerializer.SerializedWeight>, Stream<NeuralSerializer.SerializedSample>> apply(Pair<NeuralModel, Stream<NeuralSample>> neuralModelStreamPair) {
        NeuralModel model = (NeuralModel)neuralModelStreamPair.r;
        Stream samples = (Stream)neuralModelStreamPair.s;
        List<NeuralSerializer.SerializedWeight> serializedWeightList = this.neuralSerializer.serialize(model);
        Stream<NeuralSerializer.SerializedSample> serializedSampleStream = samples.map(this.neuralSerializer::serialize);
        return new Pair<List<NeuralSerializer.SerializedWeight>, Stream<NeuralSerializer.SerializedSample>>(serializedWeightList, serializedSampleStream);
    }
}

