/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.evaluation.results.Progress;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import networks.computation.training.strategies.TrainingStrategy;
import pipelines.Pipe;
import settings.Settings;
import utils.exporting.Exporter;
import utils.generic.Pair;

public class NeuralTrainingPipe
extends Pipe<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> {
    private static final Logger LOG = Logger.getLogger(NeuralTrainingPipe.class.getName());
    Settings settings;
    TrainingStrategy trainingStrategy;

    public NeuralTrainingPipe(Settings settings) {
        super("NeuralTrainingPipe");
        this.settings = settings;
    }

    protected NeuralTrainingPipe(String id) {
        super(id);
    }

    @Override
    public Pair<NeuralModel, Progress> apply(Pair<NeuralModel, Stream<NeuralSample>> neuralModelStreamPair) {
        NeuralModel model = (NeuralModel)neuralModelStreamPair.r;
        Stream sampleStream = (Stream)neuralModelStreamPair.s;
        this.trainingStrategy = TrainingStrategy.getFrom(this.settings, model, sampleStream);
        Pair<NeuralModel, Progress> training = this.trainingStrategy.train();
        return training;
    }

    @Override
    protected <T> void export(T outputReady) {
        if (this.exporter == null && this.parent != null) {
            this.exporter = Exporter.getFrom(this.ID, this.parent.settings);
        }
        if (this.exporter != null) {
            this.trainingStrategy.export(this.exporter);
        }
    }
}

