/*
 * Decompiled with CFR 0.152.
 */
package settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import settings.Settings;
import settings.Sources;
import utils.Utilities;
import utils.generic.Pair;

public class SourceFiles
extends Sources {
    private static final Logger LOG = Logger.getLogger(SourceFiles.class.getName());
    public File template;
    public File trainExamples;
    public File testExamples;
    public File trainQueries;
    public File testQueries;

    public SourceFiles(Settings settings) {
        super(settings);
    }

    @Override
    public Pair<Boolean, String> validate(Settings settings) {
        Pair<Boolean, String> basePair = this.isValid(settings);
        String msg = "";
        if (this.folds != null) {
            for (Sources fold : this.folds) {
                Pair<Boolean, String> foldpair = fold.validate(settings);
                Pair<Boolean, String> pair = basePair;
                Boolean.valueOf((Boolean)pair.r & (Boolean)foldpair.r);
                pair.r = pair.r;
                basePair.s = basePair.s + "due to fold: " + (String)foldpair.s;
            }
        }
        return basePair;
    }

    @Override
    public void infer(Settings settings) {
        if (this.checkForSubstring(this.trainExamples, settings.queryExampleSeparator, 2)) {
            LOG.info("Queries within train example file detected via separator " + settings.queryExampleSeparator);
            this.train.QueriesProvided = true;
        }
        if (this.checkForSubstring(this.testExamples, settings.queryExampleSeparator, 2)) {
            LOG.info("Queries within test example file detected via separator " + settings.queryExampleSeparator);
            this.test.QueriesProvided = true;
        }
        super.infer(settings);
    }

    public Pair<Boolean, String> isValid(Settings settings) {
        Pair<Boolean, String> validate = super.validate(settings);
        return validate;
    }

    public SourceFiles(Settings settings, CommandLine cmd) {
        super(settings);
        String sourcePath = cmd.getOptionValue("sourcePath", settings.sourcePath);
        if (cmd.hasOption("sources")) {
            String sources_ = cmd.getOptionValue("sources");
            this.loadFromJson(sources_);
        }
        if (cmd.hasOption("folds")) {
            String foldPrefix = cmd.getOptionValue("foldPrefix", settings.foldsPrefix);
            if (foldPrefix.contains(File.separator)) {
                LOG.severe("Invalid folds prefix name, it must not contain file separators: " + foldPrefix);
                throw new IllegalArgumentException(foldPrefix);
            }
            this.setupFromDir(settings, cmd, Paths.get(sourcePath, new String[0]).toAbsolutePath().toFile());
            this.crawlFolds(settings, cmd, settings.sourcePath, foldPrefix);
        } else {
            this.setupFromDir(settings, cmd, Paths.get(sourcePath, new String[0]).toAbsolutePath().toFile());
        }
    }

    private void crawlFolds(Settings settings, CommandLine cmd, String path, String prefix) {
        File dir = new File(path);
        File[] foldDirs = dir.listFiles((dir1, name) -> name.startsWith(prefix));
        this.folds = new ArrayList();
        for (File foldDir : foldDirs) {
            SourceFiles sFold = new SourceFiles(settings);
            sFold.parent = this;
            sFold.setupFromDir(settings, cmd, foldDir);
            this.folds.add(sFold);
            sFold.crawlFolds(settings, cmd, Paths.get(path, foldDir.toString()).toString(), prefix);
        }
    }

    private SourceFiles setupFromDir(Settings settings, CommandLine cmd, File foldDir) {
        LOG.info("Setting up sources from directory: " + foldDir + " with settings : " + settings);
        try {
            String templatePath;
            File template_;
            if (this.template != null) {
                settings.templateFile = this.template.getPath();
            }
            if ((template_ = (templatePath = cmd.getOptionValue("template", settings.templateFile)).startsWith(".") || settings.sourcePathProvided && !cmd.hasOption("template") ? Paths.get(foldDir.toString(), templatePath).toFile() : Paths.get(templatePath, new String[0]).toFile()).exists()) {
                if (this.parent != null && this.parent.templateReader != null) {
                    LOG.warning("Inconsistent setting - there are templates both in parent folder and fold folder (don't know which one to use)");
                }
                this.templateReader = new FileReader(template_);
                this.template = template_;
            } else if (this.parent != null) {
                this.templateReader = this.parent.templateReader;
            } else {
                LOG.severe("There is no template found at the specified path! : " + templatePath);
                throw new FileNotFoundException();
            }
            this.recognizeFileType(this.template.getAbsolutePath(), "template", settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There is no learning template");
        }
        try {
            if (this.trainExamples != null) {
                settings.trainExamplesFile = this.trainExamples.getPath();
            }
            String trainExamplesPath = cmd.getOptionValue("trainExamples", settings.trainExamplesFile);
            File trainExamples_ = null;
            trainExamples_ = trainExamplesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), trainExamplesPath).toFile() : Paths.get(trainExamplesPath, new String[0]).toFile();
            if (!trainExamples_.exists()) {
                LOG.warning("Could not find trainExamples file in " + trainExamplesPath + ", will try to use 'examples' file for the same purpose");
                trainExamples_ = Paths.get(foldDir.toString(), settings.trainExamplesFile2).toFile();
            }
            this.train.ExamplesReader = new FileReader(trainExamples_);
            this.trainExamples = trainExamples_;
            this.recognizeFileType(this.trainExamples.getAbsolutePath(), "trainExamples", settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no train examples");
        }
        try {
            if (this.testExamples != null) {
                settings.testExamplesFile = this.testExamples.getPath();
            }
            String testExamplesPath = cmd.getOptionValue("testExamples", settings.testExamplesFile);
            File testExamples_ = null;
            testExamples_ = testExamplesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), testExamplesPath).toFile() : Paths.get(testExamplesPath, new String[0]).toFile();
            this.test.ExamplesReader = new FileReader(testExamples_);
            this.testExamples = testExamples_;
            this.recognizeFileType(this.testExamples.getAbsolutePath(), "testExamples", settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate test examples found.");
        }
        try {
            if (this.trainQueries != null) {
                settings.trainQueriesFile = this.trainQueries.getPath();
            }
            String trainQueriesPath = cmd.getOptionValue("trainQueries", settings.trainQueriesFile);
            File trainQueries_ = null;
            trainQueries_ = trainQueriesPath.startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), trainQueriesPath).toFile() : Paths.get(trainQueriesPath, new String[0]).toFile();
            if (!trainQueries_.exists()) {
                LOG.warning("Could not find trainQueries file in " + trainQueriesPath + ", will try to use 'queries' file for the same purpose");
                trainQueries_ = Paths.get(foldDir.toString(), settings.trainQueriesFile2).toFile();
            }
            this.train.QueriesReader = new FileReader(trainQueries_);
            this.trainQueries = trainQueries_;
            this.recognizeFileType(this.trainQueries.getAbsolutePath(), "trainQueries", settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate train queries found.");
        }
        try {
            String testQueriesPath;
            if (this.testQueries != null) {
                settings.testQueriesFile = this.testQueries.getPath();
            }
            File testQueries_ = (testQueriesPath = cmd.getOptionValue("testQueries", settings.testQueriesFile)).startsWith("\\.") || settings.sourcePathProvided ? Paths.get(foldDir.toString(), testQueriesPath).toFile() : Paths.get(testQueriesPath, new String[0]).toFile();
            this.test.QueriesReader = new FileReader(testQueries_);
            this.testQueries = testQueries_;
            this.recognizeFileType(this.testQueries.getAbsolutePath(), "testQueries", settings);
        }
        catch (FileNotFoundException e) {
            LOG.info("There are no separate test queries found.");
        }
        return this;
    }

    private void recognizeFileType(String path, String sourceType, Settings settings) {
        switch (Utilities.identifyFileTypeUsingFilesProbeContentType(path)) {
            case "text/plain": {
                settings.plaintextInput = true;
                LOG.finer("Input " + sourceType + " file type identified as plain text");
                break;
            }
            case "text/x-microdvd": {
                settings.plaintextInput = true;
                LOG.finer("Input " + sourceType + " file type identified as plain text (text/x-microdvd)");
                break;
            }
            case "application/xml": {
                LOG.finer("Input " + sourceType + " file type identified as xml");
                break;
            }
            case "application/json": {
                LOG.finer("Input " + sourceType + " file type identified as json");
                break;
            }
            default: {
                LOG.warning("File type of input " + sourceType + " not recognized!");
            }
        }
    }

    public boolean checkForSubstring(File file, String substring, int numberOfLines) {
        if (file == null) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            String line;
            int i = 0;
            while ((line = bufferedReader.readLine()) != null && i++ < numberOfLines) {
                if (!line.contains(substring)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void importFromCSV(String inPath) {
    }

    public SourceFiles loadFromJson(String inPath) {
        InstanceCreator<SourceFiles> creator = new InstanceCreator<SourceFiles>(){

            @Override
            public SourceFiles createInstance(Type type) {
                return SourceFiles.this;
            }
        };
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)SourceFiles.class), creator).create();
        try {
            String json = new String(Files.readAllBytes(Paths.get(inPath, new String[0])));
            SourceFiles sources = gson.fromJson(json, SourceFiles.class);
            return sources;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportToCSV(String outPath) {
    }

    @Override
    public String exportToJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        return json;
    }
}

