/*
 * Decompiled with CFR 0.152.
 */
package settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import settings.Settings;
import settings.Source;
import settings.SourceFiles;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;
import utils.CommandLineHandler;
import utils.generic.Pair;

public class Sources {
    private static final Logger LOG = Logger.getLogger(Sources.class.getName());
    public List<Sources> folds;
    protected Sources parent;
    public Source train = new Source();
    public Source test = new Source();
    public transient Reader templateReader;
    public boolean templateProvided;
    public boolean foldFiles;
    public boolean crossvalidation = false;
    public boolean trainTest = false;
    public boolean trainOnly = false;
    public boolean testOnly = false;

    public static Sources getSources(String[] args, Settings settings) {
        CommandLineHandler cmdh = new CommandLineHandler();
        Sources sources = null;
        try {
            CommandLine cmd = cmdh.parseParams(args, settings);
            settings = settings.setupFromCommandline(cmd);
            LOG.info("Settings loaded and set up.");
            sources = Sources.setupFromCommandline(settings, cmd);
            LOG.info("Sources loaded and set up.");
        }
        catch (Exception ex) {
            LOG.severe("Unable to parse Commandline arguments into settings/source files.\n" + ex);
            System.exit(1);
        }
        settings.infer();
        Pair<Boolean, String> validation = settings.validate();
        if (!((Boolean)validation.r).booleanValue()) {
            LOG.severe("Invalid pipelines setting.\n" + (String)validation.s);
            System.exit(2);
        }
        validation = sources.validate(settings);
        if (!((Boolean)validation.r).booleanValue()) {
            LOG.severe("Invalid source files configuration.\n" + (String)validation.s);
            System.exit(2);
        }
        return sources;
    }

    public Sources(Settings settings) {
    }

    public void infer(Settings settings) {
        if (this.folds != null) {
            this.foldFiles = true;
            this.crossvalidation = true;
        } else {
            this.foldFiles = false;
        }
        if (this.templateReader == null) {
            this.templateProvided = false;
            settings.structureLearning = true;
        } else {
            this.templateProvided = true;
        }
        this.train.infer(settings);
        this.test.infer(settings);
        if (!this.crossvalidation) {
            if (this.train.QueriesProvided && this.test.QueriesProvided) {
                this.trainTest = true;
            } else if (this.train.QueriesProvided) {
                this.trainOnly = true;
            } else if (this.test.QueriesProvided) {
                if (!this.templateProvided) {
                    LOG.warning("Incosistent learning mode inference for this Source (missing template).");
                }
                this.testOnly = true;
            } else {
                LOG.warning("Incosistent learning mode inferred for this Source.");
            }
        }
        if (this.templateProvided && this.train.QueriesProvided && !this.train.ExamplesProvided) {
            settings.groundingMode = Settings.GroundingMode.GLOBAL;
        }
        this.finish(settings);
    }

    private void finish(Settings settings) {
        settings.exporter.exportSources(this);
    }

    public Pair<Boolean, String> validate(Settings settings) {
        boolean valid = true;
        String msg = "";
        this.infer(settings);
        if (!settings.allowStructureLearning && !this.templateProvided) {
            msg = msg + "Structure learning is forbidden (not implemented) but no template provided\n";
            LOG.severe(msg);
            valid = false;
        }
        if (!this.train.QueriesProvided && !this.test.QueriesProvided && this.folds == null) {
            msg = msg + "Invalid learning setup - no training queries nor testing queries provided\n";
            LOG.severe(msg);
            valid = false;
        }
        if (this.templateReader == null && this.train.QueriesReader == null && this.test.QueriesReader == null) {
            msg = msg + "Invalid learning setup - no template nor queries provided\n";
            LOG.severe(msg);
            valid = false;
        }
        if (this.crossvalidation && (this.testOnly || this.trainTest || this.trainOnly)) {
            msg = msg + "Invalid learning setup - cannot decide between crossvalidation and other modes.\n";
            LOG.severe(msg);
            valid = false;
        }
        if (this.foldFiles) {
            Pair<Boolean, String> pair = this.checkJointConsistency(this.folds);
        }
        Pair<Boolean, String> valtrain = this.train.validate(settings);
        valid &= ((Boolean)valtrain.r).booleanValue();
        msg = msg + (String)valtrain.s;
        Pair<Boolean, String> valtest = this.test.validate(settings);
        msg = msg + (String)valtest.s;
        return new Pair<Boolean, String>(valid &= ((Boolean)valtest.r).booleanValue(), msg);
    }

    private Pair<Boolean, String> checkJointConsistency(List<Sources> folds) {
        return null;
    }

    public static Sources setupFromCommandline(Settings settings, CommandLine cmd) {
        if (!settings.sourceFiles) {
            LOG.severe("Input streams other than from source files not implemented yet");
            throw new NotImplementedException();
        }
        SourceFiles sources = new SourceFiles(settings, cmd);
        if (cmd.hasOption("xval") || settings.crossvalidation) {
            sources.crossvalidation = true;
        }
        return sources;
    }

    public String exportToJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this);
        return json;
    }
}

