/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.building.End2endTrainigBuilder;
import settings.Settings;
import settings.Sources;
import utils.drawing.Drawer;
import utils.drawing.PipelineDrawer;

public abstract class Debugger<S>
extends AbstractPipelineBuilder<Sources, Stream<S>> {
    private static final Logger LOG = Logger.getLogger(Debugger.class.getName());
    S debuggingInput;
    protected Pipeline<Sources, Stream<S>> pipeline = null;
    public Drawer<S> drawer;
    protected Sources sources;
    protected End2endTrainigBuilder end2endTrainigBuilder;
    public boolean intermediateDebug;

    public Debugger(Settings settings) {
        super(settings);
    }

    public Debugger(String[] args, Settings settings) {
        this(Sources.getSources(args, settings), settings);
    }

    public Debugger(Sources sources, Settings settings) {
        super(settings);
        this.sources = sources;
        this.end2endTrainigBuilder = new End2endTrainigBuilder(settings, sources);
        this.settings.root = this.pipeline = new Pipeline(this.getClass().getSimpleName() + "Pipeline", this);
        this.intermediateDebug = settings.intermediateDebug;
    }

    public void executeDebug() {
        this.pipeline = this.buildPipeline();
        if (this.settings.debugPipeline) {
            this.drawPipeline();
        }
        this.addDebugTerminal(this.pipeline);
        this.pipeline.execute(this.sources);
    }

    public void addDebugElement(Pipeline<?, S> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<S, S>("PeekPipe"){

            @Override
            public S apply(S s) {
                Debugger.this.debug(s);
                return s;
            }
        }));
    }

    public void addDebugStream(Pipeline<?, Stream<S>> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<Stream<S>, Stream<S>>("PeekPipe"){

            @Override
            public Stream<S> apply(Stream<S> stream) {
                return stream.peek(Debugger.this::debug);
            }
        }));
    }

    public void addDebugTerminal(Pipeline<?, Stream<S>> pipeline) {
        pipeline.registerEnd(pipeline.terminal.connectAfter(new Pipe<Stream<S>, Stream<S>>("StreamTerminationPipe"){

            @Override
            public Stream<S> apply(Stream<S> stream) {
                stream.forEach(new Consumer<S>(){

                    @Override
                    public void accept(S s) {
                        Debugger.this.debug(s);
                    }
                });
                return stream;
            }
        }));
    }

    public void drawPipeline() {
        PipelineDrawer pipelineDrawer = new PipelineDrawer(this.settings);
        pipelineDrawer.draw(this.pipeline);
    }

    public Pipeline<Sources, Stream<S>> getPipeline() {
        return this.pipeline;
    }

    public abstract void debug(S var1);
}

