/*
 * Decompiled with CFR 0.152.
 */
package utils.drawing;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import settings.Settings;

public class GraphViz {
    private static final Logger LOG = Logger.getLogger(GraphViz.class.getName());
    GraphicsDevice gd;
    int width;
    int height;
    private static final int[] dpiSizes = new int[]{46, 51, 57, 63, 70, 78, 86, 96, 106, 116, 128, 141, 155, 170, 187, 206, 226, 249};
    private static final String osName = System.getProperty("os.name").replaceAll("\\s", "");
    private int currentDpiPos = 7;
    private String fileName;
    public String algorithm;
    String imgtype;
    private boolean fix2ScreenSize;
    private boolean storeImage;
    public String tempDir;
    private String executable;
    private static int counter;
    private StringBuilder graph = new StringBuilder();

    public static String sanitize(String name) {
        return "\"" + name + "\"";
    }

    private GraphViz(String executable, String tempDir) {
        this.executable = executable;
        this.tempDir = tempDir;
    }

    public GraphViz(Settings settings) {
        this(GraphViz.getGraphvizExecutable(settings), settings.outDir);
        this.fileName = settings.imageFile;
        this.algorithm = settings.graphVizAlgorithm;
        this.imgtype = settings.imgType;
        this.fix2ScreenSize = settings.fix2ScreenSize;
        this.storeImage = settings.storeNotShow;
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.width = this.gd.getDisplayMode().getWidth();
        this.height = this.gd.getDisplayMode().getHeight();
    }

    private static String getGraphvizExecutable(Settings settings) {
        if (Settings.os == Settings.OS.WINDOWS) {
            return settings.graphvizPathWindows + "/" + settings.graphVizAlgorithm + ".exe";
        }
        if (osName.contains("MacOSX")) {
            return settings.graphvizPathMac + "/" + settings.graphVizAlgorithm;
        }
        return settings.graphvizPathLinux + "/" + settings.graphVizAlgorithm;
    }

    public void increaseDpi() {
        if (this.currentDpiPos < dpiSizes.length - 1) {
            ++this.currentDpiPos;
        }
    }

    public void decreaseDpi() {
        if (this.currentDpiPos > 0) {
            --this.currentDpiPos;
        }
    }

    public int getImageDpi() {
        return dpiSizes[this.currentDpiPos];
    }

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(line + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public void uniqueLines() {
        String[] split = this.graph.toString().split("\n");
        HashSet<String> strings = new HashSet<String>();
        for (String s : split) {
            strings.add(s);
        }
        String collect = strings.stream().collect(Collectors.joining("\n"));
        this.graph = new StringBuilder(collect);
    }

    public void clearGraph() {
        this.graph = new StringBuilder();
    }

    private String getImageName(String name) {
        return this.fileName + counter++ + "_" + name + "." + this.imgtype;
    }

    private String getGraphName(String name) {
        return this.fileName + counter++ + "_" + name + "." + this.algorithm;
    }

    public void storeGraphSource(String name) throws IOException {
        try {
            File file = new File(this.getGraphName(name));
            FileWriter fout = new FileWriter(file);
            fout.write(this.getDotSource());
            fout.close();
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
        }
    }

    public byte[] getGraphImage(String nameOrEmpty) throws IOException, InterruptedException {
        String[] args = this.getArgs(nameOrEmpty);
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        bw.write(this.graph.toString());
        bw.flush();
        bw.close();
        byte[] bytes = this.readInputImageStream(process.getInputStream());
        return bytes;
    }

    private String[] getArgs(String name) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable);
        args.add("-T" + this.imgtype);
        args.add("-Gdpi=" + dpiSizes[this.currentDpiPos]);
        if (this.fix2ScreenSize) {
            args.add("-Gsize=" + this.width / dpiSizes[this.currentDpiPos] + "," + this.height / dpiSizes[this.currentDpiPos] + "\\!");
        }
        if (this.storeImage) {
            args.add("-o " + this.getImageName(name));
        }
        return args.toArray(new String[args.size()]);
    }

    private byte[] readInputImageStream(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        buffer.close();
        return buffer.toByteArray();
    }

    public byte[] getGraphUsingTemporaryFile(String dot_source, String type, String representationType) {
        byte[] img_stream = null;
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                img_stream = this.getImgStream(dot, type, representationType);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted!");
                }
                return img_stream;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int writeImageToFile(byte[] img, String file) {
        File to = new File(this.tempDir + "/" + GraphViz.sanitize(file) + "." + this.imgtype);
        return this.writeImageToFile(img, to);
    }

    public int writeImageToFile(byte[] img, File to) {
        try {
            FileOutputStream fos = new FileOutputStream(to);
            fos.write(img);
            fos.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 1;
    }

    private byte[] getImgStream(File dot, String type, String representationType) {
        byte[] img_stream = null;
        try {
            File img = File.createTempFile("graph_", "." + type, new File(this.tempDir));
            Runtime rt = Runtime.getRuntime();
            String[] args = new String[]{this.executable, "-T" + type, "-K" + representationType, "-Gdpi=" + dpiSizes[this.currentDpiPos], dot.getAbsolutePath(), "-o", img.getAbsolutePath()};
            Process p = rt.exec(args);
            int i = p.waitFor();
            if (i > 0) {
                System.err.println(i);
            }
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            if (in != null) {
                in.close();
            }
            if (!img.delete()) {
                System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
            }
        }
        catch (IOException ioe) {
            System.err.println("Error:    in I/O processing of tempfile in dir " + this.tempDir + "\n");
            System.err.println("       or in calling external command");
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            System.err.println("Error: the execution of the external program was interrupted");
            ie.printStackTrace();
        }
        return img_stream;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(this.tempDir));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    public void start_graph() {
        this.graph.append("digraph G {").append("\n");
    }

    public void end_graph() {
        this.graph.append("}").append("\n");
    }

    public void start_subgraph(int clusterid) {
        this.graph.append("subgraph cluster_" + clusterid + " {");
    }

    public void end_subgraph() {
        this.graph.append("}");
    }

    public void readSource(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            FileInputStream fis = new FileInputStream(input);
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader br = new BufferedReader(new InputStreamReader(dis));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            dis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        this.graph = sb;
    }
}

