/*
 * Decompiled with CFR 0.152.
 */
package utils.exporting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Logger;
import settings.Settings;
import settings.Sources;
import utils.exporting.Exportable;
import utils.exporting.TextExporter;

public class Exporter {
    private static final Logger LOG = Logger.getLogger(Exporter.class.getName());
    Settings settings;
    File exportFile;
    PrintWriter exportWriter;
    String id;
    String suffix = "";
    boolean crossvalDetected;

    public Exporter(Settings settings) {
        this.settings = settings;
    }

    public Exporter(Settings settings, String id) {
        if (settings == null) {
            return;
        }
        this.id = id;
        this.settings = settings;
        if (settings.blockExporting == Settings.BlockExporting.JSON) {
            this.suffix = ".json";
        }
        this.exportWriter = this.getWriter(settings.exportDir + "/" + id + this.suffix, true);
    }

    public static Exporter getFrom(String id, Settings settings) {
        if (settings == null) {
            return null;
        }
        for (String exportPipeline : settings.exportBlocks) {
            if (!id.equals(exportPipeline)) continue;
            if (settings.blockExporting == Settings.BlockExporting.TEXT) {
                return new TextExporter(settings, id);
            }
            return new Exporter(settings, id);
        }
        return null;
    }

    public void deleteDir(File file) {
        File[] contents = file.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                this.deleteDir(f);
            }
        }
        file.delete();
    }

    public void exportSettings(Settings settings) {
        LOG.info("Exporting settings to " + settings.settingsExportFile);
        PrintWriter settingsWriter = this.getWriter(settings.settingsExportFile, false);
        settingsWriter.println(settings.exportToJson());
        settingsWriter.flush();
        settingsWriter.close();
    }

    public void exportSources(Sources sources) {
        LOG.info("Exporting sources to " + this.settings.sourcesExportFile);
        PrintWriter writer = this.getWriter(this.settings.sourcesExportFile, false);
        writer.println(sources.exportToJson());
        writer.flush();
        writer.close();
    }

    public void resultsLine(String line) {
        this.exportWriter.println(line);
        this.exportWriter.println();
        this.exportWriter.flush();
    }

    private PrintWriter getWriter(String filename, boolean append) {
        FileWriter fw = null;
        try {
            this.exportFile = new File(filename);
            if (this.exportFile.getParentFile() != null) {
                this.exportFile.getParentFile().mkdirs();
            }
            if (this.exportFile.exists() && append) {
                this.crossvalDetected = true;
            }
            this.exportFile.createNewFile();
            fw = new FileWriter(filename, append);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrintWriter out = new PrintWriter(fw);
        return out;
    }

    public void export(Exportable t) {
        if (this.crossvalDetected) {
            this.repairJsonCrossvalStart(this.exportFile);
        }
        this.resultsLine(t.exportToJson());
        if (this.crossvalDetected) {
            this.repairJsonCrossvalEnd(this.exportFile);
        }
    }

    private void repairJsonCrossvalStart(File file) {
        try {
            List<String> strings = Files.readAllLines(file.toPath());
            if (strings.isEmpty()) {
                return;
            }
            if (strings.get(0).contains("[")) {
                strings.set(strings.size() - 2, ",\n");
            } else {
                strings.add(0, "[\n");
                strings.add(",\n");
            }
            FileWriter fileWriter = new FileWriter(file, false);
            PrintWriter out = new PrintWriter(fileWriter);
            for (String string : strings) {
                out.println(string);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void repairJsonCrossvalEnd(File file) {
        this.exportWriter.println("]\n");
        this.exportWriter.flush();
    }
}

