/*
 * Decompiled with CFR 0.152.
 */
package constructs;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import constructs.WeightedPredicate;
import ida.ilp.logic.Literal;
import ida.ilp.logic.Predicate;
import ida.ilp.logic.Term;
import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Activation;

public class Atom {
    private static final Logger LOG = Logger.getLogger(Atom.class.getName());
    @NotNull
    public WeightedPredicate offsettedPredicate;
    @NotNull
    public Literal literal;
    @Nullable
    public Activation activation;
    @Nullable
    public String originalString;
    public boolean dropout;

    public Atom(WeightedPredicate weightedPredicate, List<Term> terms, boolean negated) {
        if (weightedPredicate.predicate.arity != terms.size()) {
            LOG.severe("Predicate arity and terms size mismatch while creating an Atom");
        }
        this.offsettedPredicate = weightedPredicate;
        this.literal = new Literal(weightedPredicate.predicate, negated, terms);
        this.activation = this.offsettedPredicate.activation;
    }

    public Atom(Atom another) {
        this.offsettedPredicate = another.offsettedPredicate;
        this.literal = another.literal;
        this.activation = another.activation;
        this.originalString = another.originalString;
    }

    public Predicate getPredicate() {
        return this.literal.predicate();
    }

    public WeightedPredicate getOffsettedPredicate() {
        return this.offsettedPredicate;
    }

    public boolean isNegated() {
        return this.literal.isNegated();
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)obj;
        return this.literal.equals(other.literal);
    }

    public String toString() {
        return this.literal.toString();
    }

    public Activation getActivation() {
        if (this.activation != null) {
            return this.activation;
        }
        if (this.offsettedPredicate.activation != null) {
            return this.offsettedPredicate.activation;
        }
        return null;
    }
}

