/*
 * Decompiled with CFR 0.152.
 */
package constructs.template.components;

import constructs.template.components.GroundHeadRule;
import constructs.template.components.WeightedRule;
import ida.ilp.logic.Literal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class GroundRule
extends GroundHeadRule {
    private static final Logger LOG = Logger.getLogger(GroundRule.class.getName());
    public Literal[] groundBody;

    public GroundRule(WeightedRule weightedRule, Literal groundHead, Literal[] groundBody) {
        super(weightedRule, groundHead);
        this.groundBody = groundBody;
    }

    @Override
    public String toFullString() {
        return "(" + this.groundHead.toString() + ":-" + Arrays.toString(this.groundBody) + ") -> " + this.weightedRule.getOriginalString();
    }

    public String toString() {
        return this.groundHead.toString() + ":-" + Arrays.toString(this.groundBody);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroundRule that = (GroundRule)o;
        return Objects.equals(this.weightedRule, that.weightedRule) && Objects.equals(this.groundHead, that.groundHead) && Arrays.equals(this.groundBody, that.groundBody);
    }

    @Override
    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = super.hashCode();
        this.hashCode = 17 * this.hashCode + Arrays.hashCode(this.groundBody);
        return this.hashCode;
    }

    @Override
    public void internLiterals(Map<Literal, Literal> herbrand) {
        super.internLiterals(herbrand);
        for (int i = 0; i < this.groundBody.length; ++i) {
            this.groundBody[i] = herbrand.get(this.groundBody[i]);
        }
    }
}

