/*
 * Decompiled with CFR 0.152.
 */
package constructs.template.metadata;

import constructs.template.components.WeightedRule;
import constructs.template.metadata.Metadata;
import constructs.template.metadata.Parameter;
import constructs.template.metadata.ParameterValue;
import java.util.Map;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Activation;
import networks.computation.evaluation.functions.Aggregation;
import networks.computation.evaluation.functions.CrossProduct;
import settings.Settings;

public class RuleMetadata
extends Metadata<WeightedRule> {
    private static final Logger LOG = Logger.getLogger(RuleMetadata.class.getName());

    public RuleMetadata(Settings settings, Map<String, Object> stringObjectMap) {
        super(settings, stringObjectMap);
    }

    @Override
    public boolean addValidateMetadatum(String parameterText, Object value) {
        Aggregation aggregation;
        Parameter parameter = new Parameter(parameterText);
        ParameterValue parameterValue = new ParameterValue(value);
        boolean valid = false;
        if (parameter.type == Parameter.Type.OFFSET && parameterValue.type == ParameterValue.Type.VALUE) {
            valid = true;
        } else if (parameter.type == Parameter.Type.LEARNABLE && parameterValue.type == ParameterValue.Type.BOOLEAN) {
            valid = true;
        } else if (parameter.type == Parameter.Type.ACTIVATION && parameterValue.type == ParameterValue.Type.STRING && (aggregation = Activation.parseActivation(parameterValue.stringValue)) != null) {
            valid = true;
            parameterValue.value = aggregation;
        }
        if (valid) {
            this.metadata.put(parameter, parameterValue);
        }
        return true;
    }

    @Override
    public void applyTo(WeightedRule object) {
        this.metadata.forEach((param, value) -> this.apply(object, (Parameter)param, (ParameterValue)value));
    }

    private void apply(WeightedRule object, Parameter param, ParameterValue value) {
        if (param.type == Parameter.Type.ACTIVATION) {
            if (value.value instanceof CrossProduct) {
                object.setActivationFcn(object.getActivationFcn() != null ? new CrossProduct(object.getActivationFcn()) : new CrossProduct(Activation.getActivationFunction(this.settings.ruleNeuronActivation)));
            }
            object.setActivationFcn((Activation)value.value);
        }
    }
}

