/*
 * Decompiled with CFR 0.152.
 */
package grounding.debugging;

import constructs.building.factories.WeightFactory;
import constructs.example.LogicSample;
import constructs.template.Template;
import grounding.GroundingSample;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipeline;
import settings.Settings;
import settings.Sources;
import utils.Debugger;
import utils.drawing.GroundingDrawer;
import utils.generic.Pair;

public class GroundingDebugger
extends Debugger<GroundingSample> {
    private static final Logger LOG = Logger.getLogger(GroundingDebugger.class.getName());
    WeightFactory weightFactory;

    public GroundingDebugger(Settings settings) {
        super(settings);
        this.drawer = new GroundingDrawer(settings);
    }

    public GroundingDebugger(String[] args, Settings settings) {
        super(args, settings);
        this.weightFactory = new WeightFactory();
        this.drawer = new GroundingDrawer(settings);
    }

    public GroundingDebugger(Sources sources, Settings settings) {
        super(sources, settings);
        this.drawer = new GroundingDrawer(settings);
    }

    @Override
    public void debug(GroundingSample sample) {
        this.drawer.draw(sample);
    }

    public WeightFactory getWeightFactory() {
        return this.weightFactory;
    }

    @Override
    public Pipeline<Sources, Stream<GroundingSample>> buildPipeline() {
        Pipeline<Sources, Pair<Template, Stream<LogicSample>>> sourcesPairPipeline = this.pipeline.registerStart(this.end2endTrainigBuilder.buildFromSources(this.sources, this.settings));
        Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline = this.pipeline.registerEnd(this.end2endTrainigBuilder.buildGrounding(this.settings, this.weightFactory));
        sourcesPairPipeline.connectAfter(groundingPipeline);
        return this.pipeline;
    }
}

