/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic.subsumption;

import ida.ilp.logic.Clause;
import ida.ilp.logic.Constant;
import ida.ilp.logic.Literal;
import ida.ilp.logic.LogicUtils;
import ida.ilp.logic.Term;
import ida.ilp.logic.Variable;
import ida.ilp.logic.subsumption.SubsumptionEngineJ2;
import ida.utils.IntegerFunction;
import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.collections.MultiList;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Matching {
    public static final int THETA_SUBSUMPTION = 1;
    public static final int OI_SUBSUMPTION = 2;
    private List<SubsumptionEngineJ2.ClauseE> examples = new ArrayList<SubsumptionEngineJ2.ClauseE>();
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int UNDECIDED = 3;
    private int resumerVersion = 2;
    private SubsumptionEngineJ2 engine;
    private boolean adaptPropagationStrength = false;
    private boolean learnVariableOrdering = true;
    private Random random = new Random();

    public Matching() {
        this.engine = new SubsumptionEngineJ2();
        this.engine.setRestartSequence(new IntegerFunction.Exponential(50, 2, 500));
    }

    public Matching(List<Clause> examples) {
        this(new SubsumptionEngineJ2(), examples);
    }

    public Matching(SubsumptionEngineJ2 engine, List<Clause> examples) {
        this.engine = engine;
        this.engine.setRestartSequence(new IntegerFunction.Exponential(50, 2, 500));
        for (Clause e : examples) {
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            this.examples.add(subsumptionEngineJ2.new SubsumptionEngineJ2.ClauseE(e));
        }
    }

    public void setRestartSequence(IntegerFunction f) {
        this.engine.setRestartSequence(f);
    }

    public int[] evaluateOnExamples(Clause hypothesis, boolean[] undecided) {
        return this.evaluateExamples(hypothesis, this.examples, undecided);
    }

    private int[] evaluateExamples(Clause hypothesis, List<SubsumptionEngineJ2.ClauseE> examples, boolean[] undecided) {
        int[] retVal = new int[undecided.length];
        undecided = VectorUtils.copyArray(undecided);
        Arrays.fill(retVal, 3);
        for (Clause component : hypothesis.connectedComponents()) {
            int[] result = this.evaluateExamplesAgainstOneComponent(component, examples, undecided);
            for (int i = 0; i < result.length; ++i) {
                if (undecided[i] && result[i] == 2) {
                    retVal[i] = 2;
                    undecided[i] = false;
                    continue;
                }
                if (!undecided[i] || result[i] != 1) continue;
                retVal[i] = 1;
            }
        }
        return retVal;
    }

    private int[] evaluateExamplesAgainstOneComponent(Clause hypothesis, List<SubsumptionEngineJ2.ClauseE> examples, boolean[] undecided) {
        double t2;
        SubsumptionEngineJ2.ClauseC c = null;
        if (this.resumerVersion < 3) {
            SubsumptionEngineJ2 subsumptionEngineJ2 = this.engine;
            subsumptionEngineJ2.getClass();
            c = subsumptionEngineJ2.new SubsumptionEngineJ2.ClauseC(hypothesis);
        }
        int[] result = new int[undecided.length];
        int j = 0;
        this.engine.setFirstVariableOrder(null);
        boolean UP = false;
        boolean DOWN = true;
        int shift = this.random.nextInt(2);
        boolean[] shiftOrNot = VectorUtils.randomBooleanVector(undecided.length, this.random);
        long time1 = 0L;
        int maxRestart = 0;
        if (this.adaptPropagationStrength) {
            if (shift == 0) {
                this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() + 1);
            } else if (shift == 1) {
                this.engine.setArcConsistencyFrom(Math.max(1, this.engine.getArcConsistencyFrom() - 1));
            }
        }
        long m1 = System.currentTimeMillis();
        for (int i = 0; i < undecided.length; ++i) {
            if (!undecided[i] || !shiftOrNot[i]) continue;
            if (j > 0 && this.learnVariableOrdering) {
                this.engine.setFirstVariableOrder(this.engine.getLastVariableOrder());
            }
            Boolean succ = this.engine.solveWithResumer(c, examples.get(i), this.resumerVersion);
            maxRestart = Math.max(this.engine.getNoOfRestarts(), maxRestart);
            if (!this.engine.solvedWithoutSearch()) {
                ++j;
            }
            result[i] = succ == null ? 3 : (succ != false ? 1 : 2);
        }
        long m2 = System.currentTimeMillis();
        time1 = m2 - m1;
        if (this.adaptPropagationStrength) {
            if (shift == 0) {
                this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() - 1);
            } else {
                this.engine.setArcConsistencyFrom(Math.max(0, this.engine.getArcConsistencyFrom() + 1));
            }
        }
        m1 = System.currentTimeMillis();
        for (int i = 0; i < undecided.length; ++i) {
            if (!undecided[i] || shiftOrNot[i]) continue;
            if (j > 0 && this.learnVariableOrdering) {
                this.engine.setFirstVariableOrder(this.engine.getLastVariableOrder());
            }
            Boolean succ = this.engine.solveWithResumer(c, examples.get(i), this.resumerVersion);
            maxRestart = Math.max(this.engine.getNoOfRestarts(), maxRestart);
            if (!this.engine.solvedWithoutSearch()) {
                ++j;
            }
            result[i] = succ == null ? 3 : (succ != false ? 1 : 2);
        }
        m2 = System.currentTimeMillis();
        long time2 = m2 - m1;
        double t1 = (double)time1 / (double)VectorUtils.occurrences(VectorUtils.and(undecided, shiftOrNot), true);
        if (t1 < (t2 = (double)time2 / (double)VectorUtils.occurrences(VectorUtils.and(undecided, VectorUtils.not(shiftOrNot)), true)) && this.adaptPropagationStrength) {
            if (shift == 0) {
                if (maxRestart > this.engine.getArcConsistencyFrom() && this.engine.getArcConsistencyFrom() > 1) {
                    this.engine.setArcConsistencyFrom(this.engine.getArcConsistencyFrom() + 1);
                }
            } else if (shift == 1) {
                this.engine.setArcConsistencyFrom(Math.max(1, this.engine.getArcConsistencyFrom() - 1));
            }
        }
        return result;
    }

    public void setSubsumptionMode(int mode) {
        this.engine.setSubsumptionMode(mode);
    }

    public void setForwardCheckingStartsIn(int restart) {
        this.engine.setForwardCheckingFrom(restart);
    }

    public void setArcConsistencyStartsIn(int restart) {
        this.engine.setArcConsistencyFrom(restart);
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public void setAdaptPropagationStrength(boolean adaptPropagationStrength) {
        this.adaptPropagationStrength = adaptPropagationStrength;
    }

    public SubsumptionEngineJ2 getEngine() {
        return this.engine;
    }

    public SubsumptionEngineJ2.ClauseC createClauseC(Clause c) {
        return this.engine.createCluaseC(c);
    }

    public SubsumptionEngineJ2.ClauseE createClauseE(Clause e) {
        return this.engine.createClauseE(e);
    }

    public Boolean subsumption(SubsumptionEngineJ2.ClauseC c, SubsumptionEngineJ2.ClauseE e) {
        return this.engine.solveWithResumer(c, e, this.resumerVersion);
    }

    public Boolean subsumption(Clause c, Clause e) {
        if (this.engine.subsumptionMode() == 1) {
            for (Clause component : c.connectedComponents()) {
                if (this.engine.solveWithResumer(component, e, this.resumerVersion).booleanValue()) continue;
                return false;
            }
        } else {
            return this.engine.solveWithResumer(c, e, this.resumerVersion);
        }
        return true;
    }

    public Boolean subsumption(Clause c, int index) {
        return this.subsumption(this.createClauseC(c), this.examples.get(index));
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, Clause e, int maxCount) {
        return this.engine.allSolutions(c, e, maxCount);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, Clause e, int maxCount, int depth) {
        return this.engine.allSolutions(c, e, maxCount, depth);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, Clause e) {
        return this.allSubstitutions(c, e, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, int exampleIndex, int maxCount) {
        SubsumptionEngineJ2.ClauseC clauseC = this.engine.createCluaseC(c);
        return this.engine.allSolutions(clauseC, this.examples.get(exampleIndex), maxCount);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(Clause c, int exampleIndex, int maxCount, int depth) {
        SubsumptionEngineJ2.ClauseC clauseC = this.engine.createCluaseC(c);
        return this.engine.allSolutions(clauseC, this.examples.get(exampleIndex), maxCount, depth);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(SubsumptionEngineJ2.ClauseC c, SubsumptionEngineJ2.ClauseE e, int maxCount) {
        return this.engine.allSolutions(c, e, maxCount, Integer.MAX_VALUE);
    }

    public Pair<Term[], List<Term[]>> allSubstitutions(SubsumptionEngineJ2.ClauseC c, SubsumptionEngineJ2.ClauseE e, int maxCount, int depth) {
        return this.engine.allSolutions(c, e, maxCount, depth);
    }

    @Deprecated
    public Pair<Term[], List<Term[]>> allTrueGroundings(Clause c, int exampleIndex) {
        ArrayList<Literal> auxLiterals = new ArrayList<Literal>();
        for (Variable v : c.variables()) {
            auxLiterals.add(new Literal("", true, v));
        }
        Clause aux = new Clause(auxLiterals);
        Pair<Term[], List<Term[]>> allGroundings = this.allSubstitutions(aux, exampleIndex, Integer.MAX_VALUE);
        Set<Object> grSet = new LinkedHashSet();
        for (Object grounding : (List)allGroundings.s) {
            HashMap<Term, Object> gr = new HashMap<Term, Object>();
            for (int i = 0; i < ((Object)grounding).length; ++i) {
                gr.put(((Term[])allGroundings.r)[i], grounding[i]);
            }
            grSet.add(gr);
        }
        ArrayList<Literal> flippedSignLiterals = new ArrayList<Literal>();
        for (Literal literal : c.literals()) {
            flippedSignLiterals.add(literal.negation());
        }
        Clause negation = new Clause(flippedSignLiterals);
        Pair<Term[], List<Term[]>> negGroundings = this.allSubstitutions(negation, exampleIndex, Integer.MAX_VALUE);
        HashSet negSet = new HashSet();
        for (Term[] grounding : (List)negGroundings.s) {
            LinkedHashMap<Term, Term> linkedHashMap = new LinkedHashMap<Term, Term>();
            for (int i = 0; i < grounding.length; ++i) {
                linkedHashMap.put(((Term[])negGroundings.r)[i], grounding[i]);
            }
            negSet.add(linkedHashMap);
        }
        grSet = Sugar.setDifference(grSet, negSet);
        ArrayList<Term[]> retList = new ArrayList<Term[]>();
        for (Map map : grSet) {
            Term[] grounding = new Term[((Term[])allGroundings.r).length];
            for (int i = 0; i < grounding.length; ++i) {
                grounding[i] = (Term)map.get(((Term[])allGroundings.r)[i]);
            }
            retList.add(grounding);
        }
        return new Pair<Term[], List<Term[]>>((Term[])allGroundings.r, (List<Term[]>)retList);
    }

    public Clause thetaReduction(Clause clause) {
        boolean reduced;
        HashSet closed = new HashSet();
        do {
            reduced = false;
            for (Literal l : clause.literals()) {
                if (closed.contains(l)) continue;
                Pair<Term[], List<Term[]>> substitutions = this.allSubstitutions(clause, new Clause(Sugar.setDifference(clause.literals(), Sugar.set(l))), 1);
                if (((List)substitutions.s).size() <= 0) continue;
                clause = LogicUtils.substitute(clause, (Term[])substitutions.r, (Term[])((List)substitutions.s).get(0));
                reduced = true;
            }
        } while (reduced);
        return clause;
    }

    public void setResumerVersion(int version) {
        this.resumerVersion = version;
    }

    public void setLearnVariableOrdering(boolean learn) {
        this.learnVariableOrdering = learn;
    }

    public void setRandomSeed(long seed) {
        this.random = new Random(seed);
        this.engine.setRandomSeed(seed);
    }

    private Clause preprocessForIsomorphismCheck(Clause c) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        for (Literal l : c.literals()) {
            Literal newLiteral = new Literal(l.isNegated() ? "~!" : "~" + l.predicateName(), l.arity());
            for (int i = 0; i < newLiteral.arity(); ++i) {
                newLiteral.set(l.get(i), i);
            }
            literals.add(newLiteral);
        }
        return new Clause(literals);
    }

    public boolean isomorphism(Clause a, Clause b) {
        if (a.variables().size() != b.variables().size() || a.countLiterals() != b.countLiterals() || !a.predicates().equals(b.predicates())) {
            return false;
        }
        Matching m = new Matching();
        m.setSubsumptionMode(2);
        m.setResumerVersion(this.resumerVersion);
        m.setAdaptPropagationStrength(this.adaptPropagationStrength);
        m.setForwardCheckingStartsIn(this.engine.getForwardCheckingFrom());
        m.setArcConsistencyStartsIn(this.engine.getArcConsistencyFrom());
        m.setLearnVariableOrdering(this.learnVariableOrdering);
        m.setRestartSequence(this.engine.getRestartSequence());
        m.setTimeout(this.engine.getTimeout());
        a = this.preprocessForIsomorphismCheck(a);
        b = this.preprocessForIsomorphismCheck(b);
        return m.subsumption(a, b);
    }

    private boolean isomorphism(SubsumptionEngineJ2.ClauseC a, SubsumptionEngineJ2.ClauseE b) {
        Matching m = new Matching();
        m.setSubsumptionMode(2);
        m.setResumerVersion(this.resumerVersion);
        m.setAdaptPropagationStrength(this.adaptPropagationStrength);
        m.setForwardCheckingStartsIn(this.engine.getForwardCheckingFrom());
        m.setArcConsistencyStartsIn(this.engine.getArcConsistencyFrom());
        m.setLearnVariableOrdering(this.learnVariableOrdering);
        m.setRestartSequence(this.engine.getRestartSequence());
        m.setTimeout(this.engine.getTimeout());
        return m.subsumption(a, b);
    }

    public List<Clause> nonisomorphic(Iterable<Clause> clauses) {
        MultiList<Pair<Integer, Integer>, Clause> mm = new MultiList<Pair<Integer, Integer>, Clause>();
        for (Clause c : clauses) {
            mm.put(new Pair<Integer, Integer>(c.countLiterals(), c.variables().size()), c);
        }
        ArrayList<Clause> retVal = new ArrayList<Clause>();
        for (List<Clause> list : mm.values()) {
            retVal.addAll(this.nonisomorphic_impl(list));
        }
        return retVal;
    }

    private List<Clause> nonisomorphic_impl(Iterable<Clause> clauses) {
        HashSet<Integer> filteredOut = new HashSet<Integer>();
        List<SubsumptionEngineJ2.ClauseE> es = Sugar.funcall(clauses, new Sugar.Fun<Clause, SubsumptionEngineJ2.ClauseE>(){

            @Override
            public SubsumptionEngineJ2.ClauseE apply(Clause clause) {
                return Matching.this.createClauseE(clause);
            }
        });
        List<SubsumptionEngineJ2.ClauseC> cs = Sugar.funcall(clauses, new Sugar.Fun<Clause, SubsumptionEngineJ2.ClauseC>(){

            @Override
            public SubsumptionEngineJ2.ClauseC apply(Clause clause) {
                return Matching.this.createClauseC(clause);
            }
        });
        for (int i = 0; i < cs.size(); ++i) {
            if (filteredOut.contains(i)) continue;
            for (int j = i + 1; j < es.size(); ++j) {
                if (!this.isomorphism(cs.get(i), es.get(j))) continue;
                filteredOut.add(j);
            }
        }
        ArrayList<Clause> retVal = new ArrayList<Clause>();
        int i = 0;
        for (Clause c : clauses) {
            if (!filteredOut.contains(i)) {
                retVal.add(c);
            }
            ++i;
        }
        return retVal;
    }

    public Triple<Term[], List<Term[]>, Double> searchTreeSampler(Clause query, int exampleIndex, int subsampleSize, int l) {
        return this.searchTreeSampler(query, this.examples.get(exampleIndex), subsampleSize, l);
    }

    public Triple<Term[], List<Term[]>, Double> searchTreeSampler(Clause query, Clause db, int subsampleSize, int l) {
        return this.searchTreeSampler(query, this.createClauseE(db), subsampleSize, l);
    }

    private Triple<Term[], List<Term[]>, Double> searchTreeSampler(Clause query, SubsumptionEngineJ2.ClauseE example, int subsampleSize, int l) {
        if (!this.subsumption(this.createClauseC(query), example).booleanValue()) {
            Term[] template = new Term[query.variables().size()];
            int i = 0;
            for (Variable v : query.variables()) {
                template[i] = v;
                ++i;
            }
            return new Triple<Term[], List<Term[]>, Double>(template, new ArrayList(1), Double.NEGATIVE_INFINITY);
        }
        Triple<Term[], List<Object>, Object> retVal = new Triple(new Term[0], Sugar.list(new Term[][]{new Term[0]}), null);
        int numVars = query.variables().size();
        double logEstModelCount = 0.0;
        for (int i = 0; i < numVars; i += l) {
            retVal = this.blackBoxSampler(query, example, (Term[])retVal.r, (List)retVal.s, subsampleSize, l);
            logEstModelCount += Math.log((Double)retVal.t);
        }
        Collections.shuffle((List)retVal.s, this.random);
        if (((List)retVal.s).size() > subsampleSize) {
            retVal.s = ((List)retVal.s).subList(0, subsampleSize);
        }
        return new Triple<Term[], List<Term[]>, Double>((Term[])retVal.r, (List<Term[]>)retVal.s, logEstModelCount);
    }

    private Triple<Term[], List<Term[]>, Double> blackBoxSampler(Clause query, SubsumptionEngineJ2.ClauseE example, Term[] substitutionTemplate, List<Term[]> sampledSolutions, int k, int l) {
        Term[] variableOrder = null;
        Collections.shuffle(sampledSolutions, this.random);
        ArrayList<Term[]> retValList = new ArrayList<Term[]>();
        Term[] retValSubsTemplate = new Term[Math.min(query.variables().size(), substitutionTemplate.length + l)];
        for (int j = 0; j < Math.min(k, sampledSolutions.size()); ++j) {
            Pair<Term[], List<Term[]>> sols;
            Term[] substitution = sampledSolutions.get(j);
            Clause restrictedQuery = LogicUtils.substitute(query, substitutionTemplate, substitution);
            SubsumptionEngineJ2.ClauseC queryC = this.createClauseC(restrictedQuery);
            if (j == 0) {
                sols = this.engine.allSolutions(queryC, example, Integer.MAX_VALUE, l);
                variableOrder = this.engine.lastVariableOrder(queryC);
                System.arraycopy(substitutionTemplate, 0, retValSubsTemplate, 0, substitutionTemplate.length);
                System.arraycopy(variableOrder, 0, retValSubsTemplate, substitutionTemplate.length, Math.min(l, variableOrder.length));
            } else {
                sols = this.engine.allSolutions(queryC, example, Integer.MAX_VALUE, l, variableOrder);
            }
            for (Term[] s : (List)sols.s) {
                Term[] pseudoSol = new Term[substitution.length + Math.min(l, variableOrder.length)];
                System.arraycopy(substitution, 0, pseudoSol, 0, substitution.length);
                System.arraycopy(s, 0, pseudoSol, substitution.length, Math.min(l, variableOrder.length));
                retValList.add(pseudoSol);
            }
        }
        double avgSols = (double)retValList.size() / (double)Math.min(k, sampledSolutions.size());
        return new Triple<Term[], List<Term[]>, Double>(retValSubsTemplate, retValList, avgSols);
    }

    public Set<Set<Term>> allImages(Clause query, int exampleIndex, int maxCard) {
        return this.allImages(query, this.examples.get(exampleIndex), maxCard);
    }

    public Set<Set<Term>> allImages(Clause query, Clause db, int maxCard) {
        return this.allImages(query, this.createClauseE(db), maxCard);
    }

    private Set<Set<Term>> allImages(Clause query, SubsumptionEngineJ2.ClauseE clauseE, int maxCard) {
        List varsInQuery = Sugar.listFromCollections(query.variables());
        if (!this.subsumption(this.createClauseC(query), clauseE).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        Literal cardLiteral = new Literal("@maxcard", varsInQuery.size() + 1);
        cardLiteral.set((Term)Constant.construct(String.valueOf(maxCard)), 0);
        for (int i = 1; i < cardLiteral.arity(); ++i) {
            cardLiteral.set((Term)varsInQuery.get(i - 1), i);
        }
        SubsumptionEngineJ2.ClauseC queryC = this.createClauseC(query = new Clause(Sugar.union(query.literals(), cardLiteral)));
        if (!this.engine.solveWithResumer(queryC, clauseE, 2).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        Term[] termOrder = this.engine.lastVariableOrder(queryC);
        ArrayList<Variable> variableList = new ArrayList<Variable>();
        for (int i = 0; i < termOrder.length; ++i) {
            if (!(termOrder[i] instanceof Variable)) continue;
            variableList.add((Variable)termOrder[i]);
        }
        System.out.println(variableList);
        HashSet<Set<Term>> partial = new HashSet<Set<Term>>();
        partial.add(new HashSet());
        for (int i = 0; i < variableList.size(); ++i) {
            HashSet newPartial = new HashSet();
            for (Set set : partial) {
                ArrayList<Literal> extendedLits = new ArrayList<Literal>();
                extendedLits.addAll(query.literals());
                for (int j = 0; j < i; ++j) {
                    Literal newLit = new Literal("@in", set.size() + 1);
                    newLit.set((Term)variableList.get(j), 0);
                    int k = 1;
                    for (Term t : set) {
                        newLit.set(t, k);
                        ++k;
                    }
                    extendedLits.add(newLit);
                }
                Clause extendedQuery = new Clause(extendedLits);
                long m1 = System.nanoTime();
                SubsumptionEngineJ2.ClauseC clauseC = this.createClauseC(extendedQuery);
                Pair<Term[], List<Term[]>> sol = this.engine.allSolutions(clauseC, clauseE, Integer.MAX_VALUE, 1, (Term)variableList.get(i));
                long m2 = System.nanoTime();
                for (Term[] ts : (List)sol.s) {
                    Term term = ts[0];
                    if (this.engine.subsumptionMode() != 1 && set.contains(term)) continue;
                    Set extendedSet = Sugar.setFromCollections(set);
                    extendedSet.add(term);
                    if (extendedSet.size() > maxCard) continue;
                    newPartial.add(extendedSet);
                }
            }
            partial = newPartial;
        }
        return partial;
    }

    public Set<Set<Term>> allImages(Clause query, Clause db, int maxCard, double epsilon, double delta) {
        return this.allImages(query, this.createClauseE(db), maxCard, epsilon, delta);
    }

    private Set<Set<Term>> allImages(Clause query, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, double epsilon, double delta) {
        return null;
    }

    private Set<Set<Term>> allImages(Clause query, SubsumptionEngineJ2.ClauseE clauseE, int maxCard, boolean[][] xors) {
        List varsInQuery = Sugar.listFromCollections(query.variables());
        if (!this.subsumption(this.createClauseC(query), clauseE).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        Literal cardLiteral = new Literal("@maxcard", varsInQuery.size() + 1);
        cardLiteral.set((Term)Constant.construct(String.valueOf(maxCard)), 0);
        for (int i = 1; i < cardLiteral.arity(); ++i) {
            cardLiteral.set((Term)varsInQuery.get(i - 1), i);
        }
        SubsumptionEngineJ2.ClauseC queryC = this.createClauseC(query = new Clause(Sugar.union(query.literals(), cardLiteral)));
        if (!this.engine.solveWithResumer(queryC, clauseE, 2).booleanValue()) {
            return new HashSet<Set<Term>>();
        }
        Term[] termOrder = this.engine.lastVariableOrder(queryC);
        ArrayList<Variable> variableList = new ArrayList<Variable>();
        for (int i = 0; i < termOrder.length; ++i) {
            if (!(termOrder[i] instanceof Variable)) continue;
            variableList.add((Variable)termOrder[i]);
        }
        System.out.println(variableList);
        HashSet<Set<Term>> partial = new HashSet<Set<Term>>();
        partial.add(new HashSet());
        for (int i = 0; i < variableList.size(); ++i) {
            System.out.println("size: " + partial.size());
            HashSet newPartial = new HashSet();
            for (Set set : partial) {
                ArrayList<Literal> extendedLits = new ArrayList<Literal>();
                extendedLits.addAll(query.literals());
                for (int j = 0; j < i; ++j) {
                    Literal newLit = new Literal("@in", set.size() + 1);
                    newLit.set((Term)variableList.get(j), 0);
                    int k = 1;
                    for (Term t : set) {
                        newLit.set(t, k);
                        ++k;
                    }
                    extendedLits.add(newLit);
                }
                Clause extendedQuery = new Clause(extendedLits);
                long m1 = System.nanoTime();
                SubsumptionEngineJ2.ClauseC clauseC = this.createClauseC(extendedQuery);
                Pair<Term[], List<Term[]>> sol = this.engine.allSolutions(clauseC, clauseE, Integer.MAX_VALUE, 1, (Term)variableList.get(i));
                long m2 = System.nanoTime();
                for (Term[] ts : (List)sol.s) {
                    Term term = ts[0];
                    if (this.engine.subsumptionMode() != 1 && set.contains(term)) continue;
                    Set extendedSet = Sugar.setFromCollections(set);
                    extendedSet.add(term);
                    if (extendedSet.size() > maxCard) continue;
                    newPartial.add(extendedSet);
                }
            }
            partial = newPartial;
        }
        return partial;
    }

    protected List<SubsumptionEngineJ2.ClauseE> examples() {
        return this.examples;
    }

    public static void main(String[] args) {
        Clause c1 = Clause.parse("Year_1(c)");
        Clause c2 = Clause.parse("Year_1(b)");
        System.out.println(new Matching().subsumption(c1, c2));
    }
}

