/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.logic.subsumption;

import ida.ilp.logic.Literal;
import ida.ilp.logic.Term;
import ida.utils.StringUtils;
import ida.utils.Sugar;
import java.util.HashSet;
import java.util.Set;

public class SpecialVarargPredicates {
    public static final String ALLDIFF = "@alldiff";
    public static final String ANYPRED = "@anypred";
    public static final String TRUE = "@true";
    public static final String IN = "@in";
    public static final String MAX_CARD = "@maxcard";
    public static final String FALSE = "@false";
    public static final Set<String> SPECIAL_PREDICATES = Sugar.set("@alldiff", "@anypred", "@true", "@in", "@maxcard", "@false");

    public static Boolean isTrueGround(Literal l) {
        if (l.predicateName().equals(ALLDIFF)) {
            HashSet<Term> elements = new HashSet<Term>();
            for (int i = 0; i < l.arity(); ++i) {
                if (elements.contains(l.get(i))) {
                    return l.isNegated();
                }
                elements.add(l.get(i));
            }
            return !l.isNegated();
        }
        if (l.predicateName().equals(TRUE)) {
            return true;
        }
        if (l.predicateName().equals(FALSE)) {
            return false;
        }
        if (l.predicateName().equals(ANYPRED)) {
            return null;
        }
        if (l.predicateName().equals(IN)) {
            Term first = l.get(0);
            for (int i = 1; i < l.arity(); ++i) {
                if (!l.get(i).equals(first)) continue;
                return true;
            }
            return false;
        }
        if (l.predicateName().equals(MAX_CARD)) {
            Term first = l.get(0);
            if (!StringUtils.isNumeric(first.name())) {
                return false;
            }
            Integer cardinality = Integer.parseInt(first.name());
            HashSet<Term> terms = new HashSet<Term>();
            for (int i = 1; i < l.arity(); ++i) {
                terms.add(l.get(i));
                if (terms.size() <= cardinality) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Something went terribly wrong...");
    }
}

