/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.Sugar;
import ida.utils.VectorUtils;
import ida.utils.collections.Counters;
import ida.utils.tuples.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DoubleMultiSet {
    private int hashCode = -1;
    private double[] counts;
    private double[] values;
    public static final EmptySet emptyBag = new EmptySet();

    protected DoubleMultiSet() {
    }

    private DoubleMultiSet(double[] values, double[] counts) {
        int zeros = VectorUtils.occurrences(counts, 0.0);
        this.values = new double[values.length - zeros];
        this.counts = new double[values.length - zeros];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(counts[i] > 0.0)) continue;
            this.values[j] = values[i];
            this.counts[j] = counts[i];
            ++j;
        }
    }

    private DoubleMultiSet(double[] values) {
        this(values, false);
    }

    private DoubleMultiSet(double[] values, boolean sort) {
        if (sort) {
            Arrays.sort(values);
        }
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            ++duplicates;
        }
        this.counts = new double[values.length - duplicates];
        this.values = new double[values.length - duplicates];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            this.values[j] = values[i];
            int n = j;
            this.counts[n] = this.counts[n] + 1.0;
            if (i != values.length - 1 && values[i] == values[i + 1]) continue;
            ++j;
        }
    }

    public static DoubleMultiSet createDoubleMultiSet(double[] values) {
        Arrays.sort(values);
        if (values.length == 0) {
            return emptyBag;
        }
        return new DoubleMultiSet(values);
    }

    public static DoubleMultiSet createDoubleMultiSetFromSortedArray(double[] values) {
        if (values.length == 0) {
            return emptyBag;
        }
        return new DoubleMultiSet(values, false);
    }

    public static DoubleMultiSet createDoubleMultiSet(Counters<Double> counter) {
        ArrayList<Pair<Double, Integer>> list = new ArrayList<Pair<Double, Integer>>();
        for (Double d : counter.keySet()) {
            list.add(new Pair<Double, Integer>(d, counter.get(d)));
        }
        return DoubleMultiSet.createDoubleMultiSet(list);
    }

    public static DoubleMultiSet createDoubleMultiSet(Collection<Pair<Double, Integer>> pairs) {
        double[] values = new double[pairs.size()];
        double[] counts = new double[pairs.size()];
        List list = Sugar.listFromCollections(pairs);
        Collections.sort(list, new Comparator<Pair<Double, Integer>>(){

            @Override
            public int compare(Pair<Double, Integer> o1, Pair<Double, Integer> o2) {
                return (int)Math.signum((Double)o1.r - (Double)o2.r);
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            values[i] = (Double)((Pair)list.get((int)i)).r;
            counts[i] = ((Integer)((Pair)list.get((int)i)).s).intValue();
        }
        return new DoubleMultiSet(values, counts);
    }

    public DoubleMultiSet multiplyCounts(double multiplier) {
        return new DoubleMultiSet(VectorUtils.copyArray(this.values), VectorUtils.times(VectorUtils.copyArray(this.counts), multiplier));
    }

    public static DoubleMultiSet intersection(DoubleMultiSet a, DoubleMultiSet b) {
        if (a.isEmpty() || b.isEmpty() || a.values[0] > b.values[b.values.length - 1] || b.values[0] > a.values[a.values.length - 1]) {
            return emptyBag;
        }
        int distinctCount = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = a.values.length;
        int bLength = b.values.length;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                ++distinctCount;
                ++indexA;
                ++indexB;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (!(a.values[indexA] > b.values[indexB])) continue;
            ++indexB;
        }
        if (distinctCount == aLength) {
            return a;
        }
        if (distinctCount == bLength) {
            return b;
        }
        double[] newValues = new double[distinctCount];
        double[] newCounts = new double[distinctCount];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                newValues[index] = a.values[indexA];
                newCounts[index] = Math.min(a.counts[indexA], b.counts[indexB]);
                ++indexA;
                ++indexB;
                ++index;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (!(a.values[indexA] > b.values[indexB])) continue;
            ++indexB;
        }
        if (distinctCount == 0) {
            return emptyBag;
        }
        return new DoubleMultiSet(newValues, newCounts);
    }

    public static DoubleMultiSet union(DoubleMultiSet a, DoubleMultiSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int aLength = a.values.length;
        int bLength = b.values.length;
        if (a.values[aLength - 1] < b.values[0]) {
            double[] values = VectorUtils.concat(a.values, b.values);
            double[] counts = VectorUtils.concat(a.counts, b.counts);
            return new DoubleMultiSet(values, counts);
        }
        if (a.values[0] > b.values[bLength - 1]) {
            double[] values = VectorUtils.concat(b.values, a.values);
            double[] counts = VectorUtils.concat(b.counts, a.counts);
            return new DoubleMultiSet(values, counts);
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                if (a.values[indexA] == b.values[indexB]) {
                    ++indexA;
                    ++indexB;
                    ++count;
                    continue;
                }
                if (a.values[indexA] < b.values[indexB]) {
                    ++indexA;
                    ++count;
                    continue;
                }
                if (!(a.values[indexA] > b.values[indexB])) continue;
                ++indexB;
                ++count;
                continue;
            }
            if (indexA < aLength) {
                ++indexA;
                ++count;
                continue;
            }
            if (indexB >= bLength) continue;
            ++indexB;
            ++count;
        }
        double[] newValues = new double[count];
        double[] newCounts = new double[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                if (a.values[indexA] == b.values[indexB]) {
                    newValues[index] = a.values[indexA];
                    newCounts[index] = a.counts[indexA] + b.counts[indexB];
                    ++indexA;
                    ++indexB;
                    ++index;
                    continue;
                }
                if (a.values[indexA] < b.values[indexB]) {
                    newValues[index] = a.values[indexA];
                    newCounts[index] = a.counts[indexA];
                    ++indexA;
                    ++index;
                    continue;
                }
                if (!(a.values[indexA] > b.values[indexB])) continue;
                newValues[index] = b.values[indexB];
                newCounts[index] = b.counts[indexB];
                ++indexB;
                ++index;
                continue;
            }
            if (indexA < aLength) {
                newValues[index] = a.values[indexA];
                newCounts[index] = a.counts[indexA];
                ++indexA;
                ++index;
                continue;
            }
            if (indexB >= bLength) continue;
            newValues[index] = b.values[indexB];
            newCounts[index] = b.counts[indexB];
            ++indexB;
            ++index;
        }
        return new DoubleMultiSet(newValues, newCounts);
    }

    public static DoubleMultiSet intersection(Collection<DoubleMultiSet> sets) {
        DoubleMultiSet result = null;
        for (DoubleMultiSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = DoubleMultiSet.intersection(result, set);
        }
        return result;
    }

    public static DoubleMultiSet intersection(DoubleMultiSet ... sets) {
        DoubleMultiSet result = null;
        for (DoubleMultiSet set : sets) {
            result = result == null ? set : DoubleMultiSet.intersection(result, set);
        }
        return result;
    }

    public static DoubleMultiSet[] intersection(DoubleMultiSet[] a, DoubleMultiSet[] b) {
        DoubleMultiSet[] retVal = new DoubleMultiSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = DoubleMultiSet.intersection(a[i], b[i]);
        }
        return retVal;
    }

    public static DoubleMultiSet union(Collection<DoubleMultiSet> sets) {
        DoubleMultiSet result = null;
        for (DoubleMultiSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = DoubleMultiSet.union(result, set);
        }
        return result;
    }

    public static DoubleMultiSet union(DoubleMultiSet[] sets) {
        DoubleMultiSet result = null;
        for (DoubleMultiSet set : sets) {
            result = result == null ? set : DoubleMultiSet.union(result, set);
        }
        return result;
    }

    public static int countNonEmpty(DoubleMultiSet[] sets) {
        int count = 0;
        for (DoubleMultiSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(DoubleMultiSet[] sets) {
        int count = 0;
        for (DoubleMultiSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public boolean contains(double d) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == d) {
                    return true;
                }
                if (!(this.values[i] > d)) continue;
                return false;
            }
        }
        return Arrays.binarySearch(this.values, d) > -1;
    }

    public boolean isSubsetOf(DoubleMultiSet b) {
        if (b.isEmpty() || b.size() < this.size() || this.values[0] < b.values[0] || this.values[this.values.length - 1] > b.values[b.values.length - 1]) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 != b.values.length && !(b.values[i2] > this.values[i]) && !(b.counts[i2] > this.counts[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(DoubleMultiSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleMultiSet) {
            DoubleMultiSet cis = (DoubleMultiSet)o;
            if (this.isEmpty() != cis.isEmpty()) {
                return false;
            }
            if (cis.hashCode != -1 && this.hashCode != -1 && cis.hashCode != this.hashCode || cis.values.length != this.values.length) {
                return false;
            }
            if (cis.values[cis.values.length - 1] != this.values[this.values.length - 1]) {
                return false;
            }
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (this.values[i] == cis.values[i] && this.counts[i] == cis.counts[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void computeHashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (int)((double)(hash + 1) * (1.0 + this.values[i] * (double)i * (double)i + this.counts[i] * (double)i)) % 0xFFFFFF;
            hash += Arrays.hashCode(this.values);
        }
        this.hashCode = hash;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntegerMultiset[");
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.counts[i] + "*" + this.values[i]);
            if (i >= this.values.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public double[] values() {
        return this.values;
    }

    public double[] counts() {
        return this.counts;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends DoubleMultiSet {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(double d) {
            return false;
        }

        @Override
        public boolean isSubsetOf(DoubleMultiSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public double[] values() {
            return new double[0];
        }
    }
}

