/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.VectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class LongSet {
    private int hashCode = -1;
    private long[] values;
    public static final EmptySet emptySet = new EmptySet();

    private LongSet() {
    }

    private LongSet(long[] values) {
        this(values, false);
    }

    private LongSet(long[] values, boolean sort) {
        this.values = new long[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        if (sort) {
            Arrays.sort(this.values);
        }
    }

    public long min() {
        return this.values[0];
    }

    public long max() {
        return this.values[this.values.length - 1];
    }

    public static LongSet createLongSet(long ... values) {
        Arrays.sort(values);
        if (values.length == 0) {
            return emptySet;
        }
        return LongSet.createLongSetFromSortedArray(values);
    }

    public static LongSet createLongSetFromSortedArray(long[] values) {
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            ++duplicates;
        }
        if (duplicates > 0) {
            long[] newValues = new long[values.length - duplicates];
            int j = 0;
            for (int i = 0; i < values.length; ++i) {
                if (i != values.length - 1 && values[i] == values[i + 1]) continue;
                newValues[j] = values[i];
                ++j;
            }
            values = newValues;
        }
        if (values.length == 0) {
            return emptySet;
        }
        return new LongSet(values, false);
    }

    public static LongSet createLongSet(Set<Long> set) {
        long[] values = new long[set.size()];
        int index = 0;
        Iterator<Long> iterator = set.iterator();
        while (iterator.hasNext()) {
            long integer;
            values[index] = integer = iterator.next().longValue();
            ++index;
        }
        return LongSet.createLongSet(values);
    }

    public static LongSet createLongSetFromRange(int start, int end) {
        long[] v = new long[end - start];
        int index = 0;
        for (int i = start; i < end; ++i) {
            v[index] = i;
            ++index;
        }
        return LongSet.createLongSet(v);
    }

    public static LongSet intersection(LongSet a, LongSet b) {
        if (a.isEmpty() || b.isEmpty() || a.values[0] > b.values[b.values.length - 1] || b.values[0] > a.values[a.values.length - 1]) {
            return emptySet;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = a.values.length;
        int bLength = b.values.length;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                ++count;
                ++indexA;
                ++indexB;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (a.values[indexA] <= b.values[indexB]) continue;
            ++indexB;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        long[] newValues = new long[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                newValues[index] = a.values[indexA];
                ++indexA;
                ++indexB;
                ++index;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (a.values[indexA] <= b.values[indexB]) continue;
            ++indexB;
        }
        if (count == 0) {
            return emptySet;
        }
        LongSet set = new LongSet();
        set.values = newValues;
        return set;
    }

    public static LongSet union(LongSet a, LongSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int aLength = a.values.length;
        int bLength = b.values.length;
        long[] aValues = a.values;
        long[] bValues = b.values;
        if (a == b) {
            return a;
        }
        if (aValues[aLength - 1] < bValues[0]) {
            long[] values = VectorUtils.concat(aValues, bValues);
            return new LongSet(values);
        }
        if (aValues[0] > bValues[bLength - 1]) {
            long[] values = VectorUtils.concat(bValues, aValues);
            return new LongSet(values);
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                long aValue = aValues[indexA];
                long bValue = bValues[indexB];
                if (aValue == bValue) {
                    ++indexA;
                    ++indexB;
                    ++count;
                    continue;
                }
                if (aValue < bValue) {
                    ++indexA;
                    ++count;
                    continue;
                }
                if (aValue <= bValue) continue;
                ++indexB;
                ++count;
                continue;
            }
            if (indexA < aLength) {
                ++indexA;
                ++count;
                continue;
            }
            if (indexB >= bLength) continue;
            ++indexB;
            ++count;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        long[] newValues = new long[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                long aValue = aValues[indexA];
                long bValue = bValues[indexB];
                if (aValue == bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++indexB;
                    ++index;
                    continue;
                }
                if (aValue < bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++index;
                    continue;
                }
                if (aValue <= bValue) continue;
                newValues[index] = bValue;
                ++indexB;
                ++index;
                continue;
            }
            if (indexA < aLength) {
                newValues[index] = aValues[indexA];
                ++indexA;
                ++index;
                continue;
            }
            if (indexB >= bLength) continue;
            newValues[index] = bValues[indexB];
            ++indexB;
            ++index;
        }
        LongSet set = new LongSet();
        set.values = newValues;
        return set;
    }

    public static LongSet difference(LongSet a, LongSet b) {
        int indexA;
        if (a == b) {
            return emptySet;
        }
        if (a instanceof EmptySet) {
            return emptySet;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int indexB = 0;
        int count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            ++count;
        }
        long[] newValues = new long[count];
        indexB = 0;
        count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                newValues[count] = a.values[indexA];
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            newValues[count] = a.values[indexA];
            ++count;
        }
        if (newValues.length == 0) {
            return emptySet;
        }
        LongSet set = new LongSet();
        set.values = newValues;
        return set;
    }

    public static boolean allAreSubsets(List<LongSet> a, List<LongSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).isSubsetOf(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreSubsets(LongSet[] a, LongSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(List<LongSet> a) {
        for (LongSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(LongSet[] a) {
        for (LongSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEmpty(List<LongSet> a) {
        for (LongSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEmpty(LongSet[] a) {
        for (LongSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEmpty(LongSet[] a, boolean[] mask) {
        int i = 0;
        for (LongSet is : a) {
            if (mask[i] && !is.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean someAreEmpty(LongSet[] a, boolean[] mask) {
        int i = 0;
        for (LongSet is : a) {
            if (mask[i] && is.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean someAreSubsets(List<LongSet> a, List<LongSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).isSubsetOf(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreSubsets(LongSet[] a, LongSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreSubsets(LongSet[] a, LongSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreSubsets(LongSet[] a, LongSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(List<LongSet> a, List<LongSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEqual(LongSet[] a, LongSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(List<LongSet> a, List<LongSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).equals(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEqual(LongSet[] a, LongSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(LongSet[] a, LongSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(LongSet[] a, LongSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static LongSet intersection(Collection<LongSet> sets) {
        LongSet result = null;
        for (LongSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            result = LongSet.intersection(result, set);
        }
        return result;
    }

    public static LongSet intersection(LongSet ... sets) {
        LongSet result = null;
        for (LongSet set : sets) {
            if (set == null) continue;
            result = result == null ? set : LongSet.intersection(result, set);
        }
        return result;
    }

    public static LongSet[] intersection(LongSet[] a, LongSet[] b) {
        LongSet[] retVal = new LongSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = LongSet.intersection(a[i], b[i]);
        }
        return retVal;
    }

    public static List<LongSet> intersection(List<LongSet> a, List<LongSet> b) {
        ArrayList<LongSet> retVal = new ArrayList<LongSet>(a.size());
        Iterator<LongSet> iter1 = a.iterator();
        Iterator<LongSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(LongSet.intersection(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static LongSet union(Collection<LongSet> sets) {
        LongSet result = null;
        for (LongSet set : sets) {
            if (set == null) continue;
            if (result == null) {
                result = set;
                continue;
            }
            result = LongSet.union(result, set);
        }
        return result;
    }

    public static LongSet union(LongSet ... sets) {
        LongSet result = null;
        for (LongSet set : sets) {
            if (set == null) continue;
            result = result == null ? set : LongSet.union(result, set);
        }
        return result;
    }

    public static LongSet[] union(LongSet[] a, LongSet[] b) {
        LongSet[] retVal = new LongSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = LongSet.union(a[i], b[i]);
        }
        return retVal;
    }

    public static List<LongSet> union(List<LongSet> a, List<LongSet> b) {
        ArrayList<LongSet> retVal = new ArrayList<LongSet>(a.size());
        Iterator<LongSet> iter1 = a.iterator();
        Iterator<LongSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(LongSet.union(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static int countNonEmpty(List<LongSet> sets) {
        int count = 0;
        for (LongSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(List<LongSet> sets) {
        int count = 0;
        for (LongSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(LongSet[] sets) {
        int count = 0;
        for (LongSet is : sets) {
            if (is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countEmpty(LongSet[] sets) {
        int count = 0;
        for (LongSet is : sets) {
            if (!is.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(LongSet[] sets, boolean[] mask) {
        int count = 0;
        int i = 0;
        for (LongSet is : sets) {
            if (mask[i] && !is.isEmpty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int countEmpty(LongSet[] sets, boolean[] mask) {
        int count = 0;
        int i = 0;
        for (LongSet is : sets) {
            if (mask[i] && is.isEmpty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int sumSizes(LongSet[] sets) {
        int sum = 0;
        for (LongSet is : sets) {
            sum += is.size();
        }
        return sum;
    }

    public static int sumSizes(LongSet[] sets, boolean[] mask) {
        int sum = 0;
        int i = 0;
        for (LongSet is : sets) {
            if (mask[i]) {
                sum += is.size();
            }
            ++i;
        }
        return sum;
    }

    public boolean contains(long integer) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == integer) {
                    return true;
                }
                if (this.values[i] <= integer) continue;
                return false;
            }
        }
        return Arrays.binarySearch(this.values, integer) > -1;
    }

    public boolean isSubsetOf(LongSet b) {
        if (b.isEmpty() || b.size() < this.size() || this.values[0] < b.values[0] || this.values[this.values.length - 1] > b.values[b.values.length - 1]) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 != b.values.length && b.values[i2] <= this.values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(LongSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (o instanceof LongSet) {
            LongSet cis = (LongSet)o;
            if (this.isEmpty() != cis.isEmpty()) {
                return false;
            }
            if (cis.hashCode != -1 && this.hashCode != -1 && cis.hashCode != this.hashCode || cis.values.length != this.values.length) {
                return false;
            }
            if (cis.values[cis.values.length - 1] != this.values[this.values.length - 1]) {
                return false;
            }
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (this.values[i] == cis.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void computeHashCode() {
        long hash = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (hash + 1L) * (1L + this.values[i] * (long)i * (long)i) % 0xFFFFFFL;
        }
        this.hashCode = (int)(hash % 1L << 30);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public Set<Long> toSet() {
        LinkedHashSet<Long> retVal = new LinkedHashSet<Long>();
        for (long i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public List<Long> toList() {
        ArrayList<Long> retVal = new ArrayList<Long>();
        for (long i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "LongSet" + VectorUtils.longArrayToString(this.values);
    }

    public long[] values() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends LongSet {
        private long[] emptyArray = new long[0];

        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(long integer) {
            return false;
        }

        @Override
        public boolean isSubsetOf(LongSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public long[] values() {
            return this.emptyArray;
        }

        @Override
        public Set<Long> toSet() {
            return new HashSet<Long>(1);
        }

        @Override
        public List<Long> toList() {
            return new ArrayList<Long>(1);
        }
    }
}

