/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ValueToIndex<T> {
    private int lastIndex = 0;
    private int max = 0;
    private LinkedHashMap<T, Integer> valueToIndex = new LinkedHashMap();
    private LinkedHashMap<Integer, T> indexToValue = new LinkedHashMap();

    public ValueToIndex() {
    }

    public ValueToIndex(int startIndex) {
        this.lastIndex = startIndex;
    }

    public int valueToIndex(T t) {
        if (!this.valueToIndex.containsKey(t)) {
            this.valueToIndex.put(t, this.lastIndex);
            this.indexToValue.put(this.lastIndex, t);
            this.max = this.lastIndex++;
        }
        return this.valueToIndex.get(t);
    }

    public T indexToValue(int index) {
        if (!this.indexToValue.containsKey(index)) {
            return null;
        }
        return this.indexToValue.get(index);
    }

    public T getValue(int index) {
        return this.indexToValue.get(index);
    }

    public int getIndex(T value) {
        return this.valueToIndex.get(value);
    }

    public boolean containsValue(T value) {
        return this.valueToIndex.containsKey(value);
    }

    public boolean containsIndex(int index) {
        return this.indexToValue.containsKey(index);
    }

    public void put(int key, T value) {
        this.valueToIndex.put(value, key);
        this.indexToValue.put(key, value);
        this.lastIndex = Math.max(this.lastIndex, key + 1);
        this.max = Math.max(this.lastIndex, key);
    }

    public Set<Integer> valuesToIndices(Collection<T> coll) {
        HashSet<Integer> retVal = new HashSet<Integer>();
        for (T t : coll) {
            retVal.add(this.valueToIndex(t));
        }
        return retVal;
    }

    public Set<T> indicesToValues(Collection<Integer> coll) {
        HashSet<T> retVal = new HashSet<T>();
        for (Integer i : coll) {
            retVal.add(this.indexToValue(i));
        }
        return retVal;
    }

    public Map<T, Integer> valuesToIndicesMap() {
        return this.valueToIndex;
    }

    public Map<Integer, T> indicesToValuesMap() {
        return this.indexToValue;
    }

    public int size() {
        return this.valueToIndex.size();
    }

    public Set<T> values() {
        return this.valueToIndex.keySet();
    }

    public Set<Integer> indices() {
        return this.indexToValue.keySet();
    }

    public String toString() {
        return this.valueToIndex.toString();
    }

    public int max() {
        return this.max;
    }
}

