/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.hypergraphs;

import ida.utils.Sugar;
import ida.utils.collections.Counters;
import ida.utils.collections.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Hypergraph {
    private int lastID = -1;
    private Set<Integer> vertices = new HashSet<Integer>();
    private MultiMap<Integer, Integer> edges = new MultiMap();
    private MultiMap<Integer, Integer> vertex2edges = new MultiMap();
    private Counters<Integer> vertexDegrees = new Counters();
    private Counters<Integer> edgeDegrees = new Counters();
    private MultiMap<Integer, Integer> degree2vertex = new MultiMap();
    private MultiMap<Integer, Integer> degree2edge = new MultiMap();
    private Counters<Integer> edgesFullyContainedInOtherEdges = new Counters();

    public Hypergraph() {
    }

    public Hypergraph(Collection<Set<Integer>> edges) {
        for (Set<Integer> edge : edges) {
            this.addEdge(edge);
        }
    }

    public Hypergraph copy() {
        Hypergraph h = new Hypergraph();
        for (Map.Entry<Integer, Set<Integer>> entry : this.edges.entrySet()) {
            h.addEdge(entry.getKey(), entry.getValue());
        }
        return h;
    }

    public void addEdge(Set<Integer> edge) {
        int eid = ++this.lastID;
        this.addEdge(eid, edge);
    }

    public void addEdge(int edgeID, Set<Integer> edge) {
        if (!this.edges.containsKey(edgeID)) {
            this.vertices.addAll(edge);
            this.edges.putAll(edgeID, edge);
            this.degree2edge.remove(this.edgeDegrees.get(edgeID), edgeID);
            for (int vertex : edge) {
                this.vertex2edges.put(vertex, edgeID);
                this.degree2vertex.remove(this.vertexDegrees.get(vertex), vertex);
                this.degree2vertex.put(this.vertexDegrees.incrementPre(vertex), vertex);
                this.edgeDegrees.increment(edgeID);
            }
            this.degree2edge.put(this.edgeDegrees.get(edgeID), edgeID);
            this.edgesFullyContainedInOtherEdges.add(edgeID, this.numSuperEdges(this.edges.get(edgeID)));
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            for (int vertex : edge) {
                for (int ee : this.vertex2edges.get(vertex)) {
                    if (alreadyProcessed.contains(ee) || ee == edgeID) continue;
                    alreadyProcessed.add(ee);
                    if (!Sugar.isSubsetOf(this.edges.get(ee), edge)) continue;
                    this.edgesFullyContainedInOtherEdges.increment(ee);
                }
            }
        }
    }

    public void removeEdge(int edgeID) {
        if (this.edges.containsKey(edgeID)) {
            this.degree2edge.remove(this.edgeDegrees.get(edgeID), edgeID);
            for (int v : this.edges.get(edgeID)) {
                this.degree2vertex.remove(this.vertexDegrees.get(v), v);
                if (this.vertexDegrees.get(v) > 1) {
                    this.degree2vertex.put(this.vertexDegrees.decrementPre(v), v);
                }
                this.edgeDegrees.decrement(edgeID);
                this.vertex2edges.remove(v, edgeID);
            }
            Set<Integer> edge = this.edges.remove(edgeID);
            this.edgesFullyContainedInOtherEdges.add(edgeID, -this.edgesFullyContainedInOtherEdges.get(edgeID));
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            for (int vertex : edge) {
                for (int ee : this.vertex2edges.get(vertex)) {
                    if (alreadyProcessed.contains(ee) || ee == edgeID) continue;
                    alreadyProcessed.add(ee);
                    if (!Sugar.isSubsetOf(this.edges.get(ee), edge)) continue;
                    this.edgesFullyContainedInOtherEdges.decrement(ee);
                }
            }
        }
    }

    public void removeVertex(int vertex) {
        if (this.vertices.contains(vertex)) {
            Set<Integer> edgesContainingVertex = this.vertex2edges.get(vertex);
            this.vertices.remove(vertex);
            this.degree2vertex.remove(this.vertexDegrees.get(vertex), vertex);
            for (int edge : this.vertex2edges.get(vertex)) {
                this.edges.remove(edge, vertex);
                this.degree2edge.remove(this.edgeDegrees.get(edge), edge);
                if (this.edgeDegrees.get(edge) <= 1) continue;
                this.degree2edge.put(this.edgeDegrees.decrementPre(edge), edge);
            }
            this.vertexDegrees.add(vertex, -this.vertexDegrees.get(vertex));
            for (int edge : edgesContainingVertex) {
                this.edgesFullyContainedInOtherEdges.add(edge, this.numSuperEdges(this.edges.get(edge)) - this.numSuperEdges(Sugar.setFromCollections(this.edges.get(edge), Sugar.set(vertex))));
            }
        }
    }

    public void removeVertices(Collection<Integer> vertices) {
        for (Integer vertex : vertices) {
            this.removeVertex(vertex);
        }
    }

    public void removeEdges(Collection<Integer> edges) {
        for (Integer edge : edges) {
            this.removeEdge(edge);
        }
    }

    protected Set<Integer> getVerticesByDegree(int degree) {
        return this.degree2vertex.get(degree);
    }

    protected Set<Integer> getEdgesByDegree(int degree) {
        return this.degree2edge.get(degree);
    }

    public int countEdges() {
        return this.edges.size();
    }

    public int countVertices() {
        return this.vertices.size();
    }

    private int numSuperEdges(Set<Integer> edge) {
        Set<Integer> candidateSuperEdges = null;
        for (int vertex : edge) {
            if (candidateSuperEdges == null) {
                candidateSuperEdges = this.vertex2edges.get(vertex);
                continue;
            }
            candidateSuperEdges = Sugar.intersection(candidateSuperEdges, this.vertex2edges.get(vertex));
        }
        if (candidateSuperEdges == null) {
            return 0;
        }
        return candidateSuperEdges.size() - 1;
    }

    protected Set<Integer> getEdgesContainedInAtLeastKEdges(int k) {
        HashSet<Integer> retVal = new HashSet<Integer>();
        for (int edge : this.edges.keySet()) {
            if (this.edgesFullyContainedInOtherEdges.get(edge) < k) continue;
            retVal.add(edge);
        }
        return retVal;
    }
}

