/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.hypergraphs;

import ida.utils.Sugar;
import ida.utils.hypergraphs.Hypergraph;
import java.util.Set;

public class HypergraphUtils {
    public static boolean isTreelike(Hypergraph h) {
        return HypergraphUtils.isTreelike_impl(h.copy());
    }

    private static boolean isTreelike_impl(Hypergraph h) {
        Set<Integer> ed;
        Set<Integer> vd;
        int count = 0;
        do {
            vd = Sugar.setFromCollections(h.getVerticesByDegree(0), h.getVerticesByDegree(1));
            ed = Sugar.setFromCollections(h.getEdgesByDegree(0), h.getEdgesByDegree(1));
            for (Integer v : vd) {
                h.removeVertex(v);
            }
            for (Integer e : ed) {
                h.removeEdge(e);
            }
        } while (count++ <= 10 && (vd.size() > 0 || ed.size() > 0));
        return h.countEdges() == 0 || h.countVertices() == 0;
    }

    public static boolean isAcyclic(Hypergraph h) {
        return HypergraphUtils.isAcyclic_impl(h.copy());
    }

    private static boolean isAcyclic_impl(Hypergraph h) {
        Set<Integer> subedges;
        Set<Integer> vd;
        do {
            vd = Sugar.setFromCollections(h.getVerticesByDegree(0), h.getVerticesByDegree(1));
            subedges = h.getEdgesContainedInAtLeastKEdges(1);
            for (Integer v : vd) {
                h.removeVertex(v);
            }
            for (Integer e : subedges) {
                h.removeEdge(e);
            }
            if ((subedges.size() <= 0 || !subedges.equals(h.getEdgesContainedInAtLeastKEdges(1))) && (vd.size() <= 0 || !vd.equals(Sugar.setFromCollections(h.getVerticesByDegree(0), h.getVerticesByDegree(1))))) continue;
            throw new RuntimeException("A big problem here");
        } while (vd.size() > 0 || subedges.size() > 0);
        return h.countEdges() == 0 || h.countVertices() == 0;
    }
}

