/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.tuples;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Tuple<T> {
    private int id;
    private static int lastID = 0;
    private int extraInt = 0;
    private T[] values;
    private int hashCode;
    private boolean hashCodeComputed = false;

    public Tuple(int n) {
        this.values = new Object[n];
        this.id = lastID++;
    }

    public Tuple(Set<T> set) {
        this(set.size());
        int index = 0;
        for (T t : set) {
            this.set(t, index);
            ++index;
        }
    }

    public Tuple(T ... ts) {
        this(ts.length);
        int index = 0;
        for (T t : ts) {
            this.set(t, index);
            ++index;
        }
    }

    public Tuple(List<T> list) {
        this(list.size());
        this.setAll(list);
    }

    public void set(T value, int index) {
        this.hashCodeComputed = false;
        this.values[index] = value;
    }

    public T get(int index) {
        return this.values[index];
    }

    public void setAll(List<T> list) {
        this.hashCodeComputed = false;
        for (int i = 0; i < list.size(); ++i) {
            this.values[i] = list.get(i);
        }
    }

    public int size() {
        return this.values.length;
    }

    public List<T> toList() {
        ArrayList<T> retVal = new ArrayList<T>();
        for (int i = 0; i < this.values.length; ++i) {
            retVal.add(this.values[i]);
        }
        return retVal;
    }

    public Set<T> toSet() {
        HashSet<T> set = new HashSet<T>();
        for (T t : this.values) {
            set.add(t);
        }
        return set;
    }

    public int hashCode() {
        if (this.hashCodeComputed) {
            return this.hashCode;
        }
        this.hashCode = 1;
        for (int i = 0; i < this.values.length; ++i) {
            this.hashCode = (this.hashCode + 1) * (this.values[i].hashCode() + i * i * i + 1) % 0xFFFFFF;
        }
        this.hashCodeComputed = true;
        return this.hashCode;
    }

    public static Tuple<Integer> intTuple(int[] array) {
        Tuple<Integer> t = new Tuple<Integer>(array.length);
        t.values = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            ((Integer[])t.values)[i] = array[i];
        }
        return t;
    }

    public static Tuple<Double> doubleTuple(double[] array) {
        Tuple<Double> t = new Tuple<Double>(array.length);
        t.values = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            ((Double[])t.values)[i] = new Double(array[i]);
        }
        return t;
    }

    public static Tuple<Boolean> booleanTuple(boolean[] array) {
        Tuple<Boolean> t = new Tuple<Boolean>(array.length);
        for (int i = 0; i < array.length; ++i) {
            ((Boolean[])t.values)[i] = array[i];
        }
        return t;
    }

    public static Tuple<String> parse(String str) {
        str = str.trim().substring(1, str.length() - 1);
        String[] splitted = str.split(",");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = splitted[i].trim();
        }
        return new Tuple<String>(splitted);
    }

    public static Tuple<Integer> parseIntegerTuple(String str) {
        Tuple<String> strTuple = Tuple.parse(str);
        int[] values = new int[strTuple.size()];
        for (int i = 0; i < strTuple.size(); ++i) {
            values[i] = Integer.parseInt(strTuple.values[i].toString());
        }
        return Tuple.intTuple(values);
    }

    public static Tuple<Double> parseDoubleTuple(String str) {
        Tuple<String> strTuple = Tuple.parse(str);
        double[] values = new double[strTuple.size()];
        for (int i = 0; i < ((String[])strTuple.values).length; ++i) {
            values[i] = Integer.parseInt(((String[])strTuple.values)[i]);
        }
        return Tuple.doubleTuple(values);
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            Tuple nt = (Tuple)o;
            if (nt.values.length != this.values.length || nt.hashCode() != this.hashCode()) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null && nt.values[i] == null || this.values[i].equals(nt.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> Tuple<T> append(Tuple<T> a, T t) {
        Tuple<T> c = new Tuple<T>(a.size() + 1);
        System.arraycopy(a.values, 0, c.values, 0, a.values.length);
        c.values[c.values.length - 1] = t;
        return c;
    }

    public static <T> Tuple<T> merge(Tuple<T> a, Tuple<T> b) {
        Tuple<T> c = new Tuple<T>(a.size() + b.size());
        System.arraycopy(a.values, 0, c.values, 0, a.values.length);
        System.arraycopy(b.values, 0, c.values, a.size(), b.values.length);
        return c;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) {
                sb.append("null");
            } else {
                sb.append(this.values[i].toString());
            }
            if (i >= this.values.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int id() {
        return this.id;
    }

    public int getExtraInt() {
        return this.extraInt;
    }

    public void setExtraInt(int extras) {
        this.extraInt = extras;
    }
}

