/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.functions;

import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.specific.Average;
import networks.computation.evaluation.functions.specific.Maximum;
import networks.computation.evaluation.functions.specific.Sum;
import networks.computation.evaluation.values.Value;
import networks.structure.metadata.states.AggregationState;
import settings.Settings;
import utils.generic.Pair;

public abstract class Aggregation {
    private static final Logger LOG = Logger.getLogger(Aggregation.class.getName());

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract Aggregation replaceWithSingleton();

    public abstract Value evaluate(List<Value> var1);

    public abstract Value differentiate(List<Value> var1);

    public static Aggregation getAggregation(Settings.AggregationFcn aggregationFcn) {
        switch (aggregationFcn) {
            case AVG: {
                return Singletons.average;
            }
            case MAX: {
                return Singletons.maximum;
            }
            case SUM: {
                return Singletons.sum;
            }
        }
        LOG.severe("Unimplemented aggregation function");
        return null;
    }

    public Pair<Double, Double> getSaturationRange() {
        return null;
    }

    public abstract boolean isInputSymmetric();

    public abstract AggregationState getAggregationState();

    public static interface State {
        public void cumulate(Value var1);

        public void invalidate();

        public int[] getInputMask();

        public Value gradient();

        public Value evaluate();
    }

    public static class Singletons {
        public static Average average = new Average();
        public static Maximum maximum = new Maximum();
        public static Sum sum = new Sum();
    }
}

