/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.functions.specific;

import java.util.logging.Logger;
import networks.computation.evaluation.functions.ErrorFcn;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;

public class Crossentropy
implements ErrorFcn {
    private static final Logger LOG = Logger.getLogger(Crossentropy.class.getName());
    static ScalarValue oneHalf = new ScalarValue(0.5);
    static ScalarValue one = new ScalarValue(1.0);
    static ScalarValue minusOne = new ScalarValue(-1.0);
    static Crossentropy singleton = new Crossentropy();

    @Override
    public Value evaluate(Value output, Value target) {
        if (target.greaterThan((Value)oneHalf)) {
            return output.apply(x -> -Math.log(x));
        }
        return output.apply(x -> -Math.log(1.0 - x));
    }

    @Override
    public Value differentiate(Value output, Value target) {
        if (target.greaterThan((Value)oneHalf)) {
            return output.apply(x -> 1.0 / x);
        }
        return output.apply(x -> -1.0 / (1.0 - x));
    }

    @Override
    public ErrorFcn getSingleton() {
        return singleton;
    }
}

