/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.functions.specific;

import java.util.function.Function;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Activation;
import networks.structure.metadata.states.AggregationState;
import utils.generic.Pair;

public class LukasiewiczSigmoid
extends Activation {
    private static final Logger LOG = Logger.getLogger(LukasiewiczSigmoid.class.getName());
    static Function<Double, Double> logist = in -> in > 100.0 ? 1.0 : (in < -100.0 ? 0.0 : 1.0 / (1.0 + Math.exp(-6.0 * in - 0.5)));

    @Override
    public String getName() {
        return "Lukasiewicz";
    }

    public LukasiewiczSigmoid() {
        super(logist, in -> in > 100.0 || in < -100.0 ? 0.0 : logist.apply((Double)in) * (1.0 - logist.apply((Double)in)));
    }

    @Override
    public AggregationState getAggregationState() {
        return new AggregationState.ActivationState(this);
    }

    @Override
    public LukasiewiczSigmoid replaceWithSingleton() {
        return Activation.Singletons.lukasiewiczSigmoid;
    }

    @Override
    public Pair<Double, Double> getSaturationRange() {
        return new Pair<Double, Double>(0.01, 0.99);
    }

    @Override
    public boolean isInputSymmetric() {
        return true;
    }
}

