/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.functions.specific;

import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Aggregation;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.structure.metadata.states.AggregationState;

public class Maximum
extends Aggregation {
    private static final Logger LOG = Logger.getLogger(Maximum.class.getName());

    @Override
    public Maximum replaceWithSingleton() {
        return Aggregation.Singletons.maximum;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        Value max = inputs.get(0);
        for (int i = 1; i < inputs.size(); ++i) {
            Value value = inputs.get(i);
            if (!value.greaterThan(max)) continue;
            max = value;
        }
        return max;
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        return new ScalarValue(1.0);
    }

    @Override
    public boolean isInputSymmetric() {
        return true;
    }

    @Override
    public AggregationState getAggregationState() {
        return new AggregationState.Pooling.Max(this);
    }
}

