/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.results;

import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.functions.Aggregation;
import networks.computation.evaluation.functions.specific.Average;
import networks.computation.evaluation.results.ClassificationResults;
import networks.computation.evaluation.results.DetailedClassificationResults;
import networks.computation.evaluation.results.RegressionResults;
import networks.computation.evaluation.results.Result;
import networks.computation.evaluation.values.Value;
import org.jetbrains.annotations.NotNull;
import settings.Settings;
import utils.exporting.Exportable;

public abstract class Results
implements Exportable<Results> {
    private static final Logger LOG = Logger.getLogger(Results.class.getName());
    transient Settings settings;
    @Deprecated
    public boolean evaluatedOnline;
    public transient List<Result> evaluations;
    Aggregation aggregationFcn;
    public Value error;

    public Results(@NotNull List<Result> evaluations, Settings settings) {
        if (evaluations == null) {
            Results.$$$reportNull$$$0(0);
        }
        this.evaluatedOnline = true;
        this.settings = settings;
        this.evaluations = evaluations;
        this.aggregationFcn = Results.getAggregation(settings);
        if (!evaluations.isEmpty()) {
            this.recalculate();
        }
    }

    public void addResult(Result result) {
        this.evaluations.add(result);
    }

    public String toString() {
        return this.aggregationFcn.toString() + "-error= " + this.error.toString();
    }

    public abstract boolean recalculate();

    public abstract boolean betterThan(Results var1);

    public void printOutputs() {
        for (Result evaluation : this.evaluations) {
            LOG.finer(evaluation.sampleId + " : target: " + evaluation.target + " output: " + evaluation.output.toDetailedString());
        }
    }

    private static Aggregation getAggregation(Settings settings) {
        if (settings.errorAggregationFcn == Settings.AggregationFcn.AVG) {
            return new Average();
        }
        LOG.severe("Unsupported errorAggregationFcn.");
        return null;
    }

    public abstract String toString(Settings var1);

    public boolean isEmpty() {
        return this.evaluations.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluations", "networks/computation/evaluation/results/Results", "<init>"));
    }

    private static class ClassificationFactory
    extends Factory {
        public ClassificationFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            ClassificationResults classificationResults = new ClassificationResults(outputs, this.settings);
            return classificationResults;
        }
    }

    private static class DetailedClassificationFactory
    extends Factory {
        public DetailedClassificationFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            DetailedClassificationResults detailedClassificationResults = new DetailedClassificationResults(outputs, this.settings);
            return detailedClassificationResults;
        }
    }

    private static class RegressionFactory
    extends Factory {
        public RegressionFactory(Settings aggregation) {
            super(aggregation);
        }

        @Override
        public Results createFrom(List<Result> outputs) {
            RegressionResults regressionResults = new RegressionResults(outputs, this.settings);
            return regressionResults;
        }
    }

    public static abstract class Factory {
        Settings settings;

        public Factory(Settings settings) {
            this.settings = settings;
        }

        public static Factory getFrom(Settings settings) {
            if (settings.regression) {
                return new RegressionFactory(settings);
            }
            if (settings.detailedResults) {
                return new DetailedClassificationFactory(settings);
            }
            return new ClassificationFactory(settings);
        }

        public abstract Results createFrom(List<Result> var1);
    }
}

