/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values;

import com.sun.istack.internal.NotNull;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.computation.evaluation.values.VectorValue;
import networks.computation.evaluation.values.distributions.ValueInitializer;

public class MatrixValue
extends Value {
    private static final Logger LOG = Logger.getLogger(MatrixValue.class.getName());
    public int rows;
    public int cols;
    public double[][] values;

    public MatrixValue(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows][cols];
    }

    public MatrixValue(List<List<Double>> vectors) {
        this.rows = vectors.size();
        this.cols = vectors.get(0).size();
        this.values = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.values[i][j] = vectors.get(i).get(j);
            }
        }
    }

    public MatrixValue(double[][] values) {
        this.values = values;
        this.rows = values.length;
        this.cols = values[0].length;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return new ValueIterator();
    }

    @Override
    public void initialize(ValueInitializer valueInitializer) {
        valueInitializer.initMatrix(this);
    }

    @Override
    public MatrixValue zero() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.values[i][j] = 0.0;
            }
        }
        return this;
    }

    @Override
    public MatrixValue clone() {
        MatrixValue clone = new MatrixValue(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                clone.values[i][j] = this.values[i][j];
            }
        }
        return clone;
    }

    @Override
    public MatrixValue getForm() {
        return new MatrixValue(this.rows, this.cols);
    }

    @Override
    public void transpose() {
        double[][] trValues = new double[this.cols][this.rows];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                trValues[j][i] = this.values[i][j];
            }
        }
        this.values = trValues;
        int tmp = this.rows;
        this.rows = this.cols;
        this.cols = tmp;
    }

    @Override
    public Value transposedView() {
        LOG.severe("Transposed view of a matrix (without actual transposition) not implemented, returning a transposed copy instead!");
        MatrixValue value = new MatrixValue(this.values);
        value.transpose();
        return value;
    }

    @Override
    public int[] size() {
        return new int[]{this.rows, this.cols};
    }

    @Override
    public Value apply(Function<Double, Double> function) {
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                result.values[i][j] = function.apply(this.values[i][j]);
            }
        }
        return result;
    }

    @Override
    public double get(int i) {
        return this.values[i / this.rows][i % this.cols];
    }

    @Override
    public void set(int i, double value) {
        this.values[i / this.rows][i % this.cols] = value;
    }

    @Override
    public void increment(int i, double value) {
        double[] dArray = this.values[i / this.rows];
        int n = i % this.cols;
        dArray[n] = dArray[n] + value;
    }

    @Override
    public String toString() {
        return Arrays.deepToString((Object[])this.values);
    }

    @Override
    public Value times(Value value) {
        return value.times(this);
    }

    @Override
    protected MatrixValue times(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] * value1;
            }
        }
        return clone;
    }

    @Override
    protected VectorValue times(VectorValue value) {
        if (this.rows != value.values.length) {
            LOG.severe("Matrix row length mismatch with vector length for multiplication");
            throw new ArithmeticException("Matrix row length mismatch with vector length for multiplication");
        }
        VectorValue result = new VectorValue(this.cols);
        double[] resultValues = result.values;
        double[] origValues = value.values;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n = i;
                resultValues[n] = resultValues[n] + origValues[j] * this.values[j][i];
            }
        }
        return result;
    }

    @Override
    protected MatrixValue times(MatrixValue value) {
        if (value.cols != this.rows) {
            LOG.severe("Matrix to matrix dimension mismatch for multiplication");
            throw new ArithmeticException();
        }
        MatrixValue result = new MatrixValue(value.rows, this.cols);
        double[][] lhs = value.values;
        double[][] resultValues = result.values;
        for (int i = 0; i < value.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                for (int k = 0; k < value.cols; ++k) {
                    double[] dArray = resultValues[i];
                    int n = j;
                    dArray[n] = dArray[n] + lhs[i][k] * this.values[k][j];
                }
            }
        }
        return result;
    }

    @Override
    public Value elementTimes(Value value) {
        return value.elementTimes(this);
    }

    @Override
    protected Value elementTimes(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] * value1;
            }
        }
        return clone;
    }

    @Override
    protected Value elementTimes(VectorValue value) {
        LOG.warning("Calculation vector element-wise product with matrix...");
        if (this.rows != value.values.length) {
            LOG.severe("Matrix row length mismatch with vector length for multiplication");
            throw new ArithmeticException("Matrix row length mismatch with vector length for multiplication");
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[][] resultValues = result.values;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                resultValues[i][j] = this.values[i][j] * value.values[j];
            }
        }
        return result;
    }

    @Override
    protected Value elementTimes(MatrixValue value) {
        if (value.cols != this.cols || value.rows != this.rows) {
            LOG.severe("Matrix to matrix dimension mismatch for element-wise multiplication");
        }
        MatrixValue result = value.clone();
        double[][] lhs = result.values;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                double[] dArray = lhs[i];
                int n = j;
                dArray[n] = dArray[n] * this.values[i][j];
            }
        }
        return result;
    }

    @Override
    public Value plus(Value value) {
        return value.plus(this);
    }

    @Override
    protected MatrixValue plus(ScalarValue value) {
        MatrixValue clone = this.clone();
        double value1 = value.value;
        for (int i = 0; i < clone.rows; ++i) {
            int j = 0;
            while (j < clone.cols) {
                double[] dArray = clone.values[i];
                int n = j++;
                dArray[n] = dArray[n] + value1;
            }
        }
        return clone;
    }

    @Override
    protected Value plus(VectorValue value) {
        LOG.severe("Incompatible summation of matrix plus vector ");
        return null;
    }

    @Override
    protected Value plus(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            LOG.severe("Incompatible summation of matrix plus matrix ");
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[][] resultValues = result.values;
        double[][] otherValues = value.values;
        for (int i = 0; i < result.rows; ++i) {
            for (int j = 0; j < result.cols; ++j) {
                resultValues[i][j] = this.values[i][j] + otherValues[i][j];
            }
        }
        return result;
    }

    @Override
    public Value minus(Value value) {
        return value.minus(this);
    }

    @Override
    protected Value minus(ScalarValue value) {
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[][] resultValues = result.values;
        double value1 = value.value;
        for (int i = 0; i < result.rows; ++i) {
            for (int j = 0; j < result.cols; ++j) {
                resultValues[i][j] = value1 - this.values[i][j];
            }
        }
        return result;
    }

    @Override
    protected Value minus(VectorValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - vector minus matrix");
        return null;
    }

    @Override
    protected Value minus(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            LOG.severe("Incompatible subtracting of matrix minus matrix ");
        }
        MatrixValue result = new MatrixValue(this.rows, this.cols);
        double[][] resultValues = result.values;
        double[][] otherValues = value.values;
        for (int i = 0; i < result.rows; ++i) {
            for (int j = 0; j < result.cols; ++j) {
                resultValues[i][j] = otherValues[i][j] - this.values[i][j];
            }
        }
        return result;
    }

    @Override
    public void incrementBy(Value value) {
        value.incrementBy(this);
    }

    @Override
    protected void incrementBy(ScalarValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - scalar increment by matrix");
    }

    @Override
    protected void incrementBy(VectorValue value) {
        LOG.severe("Incompatible dimensions of algebraic operation - vector increment by matrix");
    }

    @Override
    protected void incrementBy(MatrixValue value) {
        if (this.rows != value.rows || this.cols != value.cols) {
            LOG.severe("Incompatible incrementing of matrix with matrix ");
        }
        double[][] otherValues = value.values;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                double[] dArray = otherValues[i];
                int n = j;
                dArray[n] = dArray[n] + this.values[i][j];
            }
        }
    }

    @Override
    public boolean greaterThan(Value maxValue) {
        return maxValue.greaterThan(this);
    }

    @Override
    protected boolean greaterThan(ScalarValue maxValue) {
        int greater = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (!(this.values[i][j] < maxValue.value)) continue;
                ++greater;
            }
        }
        return greater > this.cols * this.rows / 2;
    }

    @Override
    protected boolean greaterThan(VectorValue maxValue) {
        LOG.severe("Incompatible dimensions of algebraic operation - vector greaterThan matrix");
        return false;
    }

    @Override
    protected boolean greaterThan(MatrixValue maxValue) {
        if (this.rows != maxValue.rows || this.cols != maxValue.cols) {
            LOG.severe("Matrix element-wise comparison dimension mismatch");
        }
        int greater = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (!(this.values[i][j] < maxValue.values[i][j])) continue;
                ++greater;
            }
        }
        return greater > this.cols * this.rows / 2;
    }

    protected class ValueIterator
    implements Iterator<Double> {
        int row;
        int col;
        final int maxCol;
        final int maxRow;

        protected ValueIterator() {
            this.maxCol = MatrixValue.this.cols - 1;
            this.maxRow = MatrixValue.this.rows - 1;
        }

        @Override
        public boolean hasNext() {
            return this.row < this.maxRow || this.col < this.maxCol;
        }

        @Override
        public Double next() {
            double next = MatrixValue.this.values[this.row][this.col];
            if (this.col < MatrixValue.this.cols - 1) {
                ++this.col;
            } else {
                ++this.row;
                this.col = 0;
            }
            return next;
        }
    }
}

