/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.evaluation.values.distributions;

import java.util.Random;
import java.util.logging.Logger;
import networks.computation.evaluation.values.distributions.Constant;
import networks.computation.evaluation.values.distributions.Uniform;
import settings.Settings;

public abstract class Distribution {
    private static final Logger LOG = Logger.getLogger(Distribution.class.getName());
    transient Settings setting;
    Random rg;
    double scale;

    public Distribution(Random rg, Settings settings) {
        this.rg = rg;
        this.scale = settings.randomInitScale;
        this.setting = settings;
    }

    public static Distribution getDistribution(Settings settings) {
        if (settings.initDistribution == Settings.InitDistribution.UNIFORM) {
            return new Uniform(settings.random, settings);
        }
        if (settings.initDistribution == Settings.InitDistribution.CONSTANT) {
            return new Constant(settings.random, settings);
        }
        LOG.warning("Wrong weights initialization setup, choosing default distribution");
        return new Uniform(settings.random, settings);
    }

    abstract double getDoubleValue();
}

