/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.visitors.neurons;

import java.util.logging.Logger;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.visitors.neurons.NeuronVisitor;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.WeightedNeuron;
import networks.structure.metadata.states.State;

public class Accumulator
extends NeuronVisitor.Weighted {
    private static final Logger LOG = Logger.getLogger(Accumulator.class.getName());
    public Value accumulated = new ScalarValue(0.0);

    public Accumulator(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor) {
        super(network, computationVisitor, null);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> neuron) {
        State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
        Value visit = this.stateVisitor.visit(state);
        this.accumulated.incrementBy(visit);
    }

    @Override
    public <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> neuron) {
        State.Neural.Computation state = neuron.getComputationView(this.stateVisitor.stateIndex);
        Value visit = this.stateVisitor.visit(state);
        this.accumulated.incrementBy(visit);
    }
}

