/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.visitors.neurons;

import com.sun.istack.internal.Nullable;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.computation.iteration.visitors.weights.WeightUpdater;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.WeightedNeuron;
import networks.structure.components.neurons.types.AggregationNeuron;
import networks.structure.components.neurons.types.AtomNeuron;
import networks.structure.components.neurons.types.FactNeuron;
import networks.structure.components.neurons.types.RuleNeuron;
import networks.structure.components.neurons.types.WeightedAtomNeuron;
import networks.structure.components.neurons.types.WeightedRuleNeuron;
import networks.structure.metadata.states.State;

public abstract class NeuronVisitor {
    protected NeuralNetwork<State.Structure> network;
    public StateVisiting.Computation stateVisitor;

    public NeuronVisitor(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor) {
        this.network = network;
        this.stateVisitor = computationVisitor;
    }

    public abstract <T extends Neurons, S extends State.Neural> void visit(BaseNeuron<T, S> var1);

    public static abstract class Weighted
    extends NeuronVisitor {
        @Nullable
        public WeightUpdater weightUpdater;

        public Weighted(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor, @Nullable WeightUpdater weightUpdater) {
            super(network, computationVisitor);
            this.weightUpdater = weightUpdater;
        }

        public abstract <T extends Neurons, S extends State.Neural> void visit(WeightedNeuron<T, S> var1);

        public static abstract class Indexed
        extends Weighted {
            public Indexed(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor, @Nullable WeightUpdater weightUpdater) {
                super(network, computationVisitor, weightUpdater);
            }

            public void visit(WeightedNeuron neuron) {
                this.visit(neuron, 0);
            }

            public void visit(BaseNeuron neuron) {
                this.visit(neuron, 0);
            }

            abstract void visit(BaseNeuron var1, int var2);

            abstract void visit(WeightedNeuron var1, int var2);
        }

        public static abstract class Detailed
        extends Weighted {
            public Detailed(NeuralNetwork<State.Structure> network, StateVisiting.Computation computationVisitor, WeightUpdater weightUpdater) {
                super(network, computationVisitor, weightUpdater);
            }

            public abstract <S extends State.Neural> void visit(AggregationNeuron<S> var1);

            public abstract <S extends State.Neural> void visit(RuleNeuron<S> var1);

            public abstract <S extends State.Neural> void visit(WeightedRuleNeuron<S> var1);

            public abstract <S extends State.Neural> void visit(WeightedAtomNeuron<S> var1);

            public abstract <S extends State.Neural> void visit(AtomNeuron<S> var1);

            public abstract void visit(FactNeuron var1);
        }
    }
}

