/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.visitors.states.neurons;

import java.util.logging.Logger;
import networks.computation.evaluation.values.ScalarValue;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.visitors.states.StateVisiting;
import networks.structure.metadata.states.State;
import utils.generic.Pair;

public class SaturationChecker
extends StateVisiting.Computation {
    private static final Logger LOG = Logger.getLogger(SaturationChecker.class.getName());

    @Override
    public Value visit(State.Neural.Computation state) {
        Value value = state.getValue();
        Pair<Double, Double> range = state.getAggregation().getSaturationRange();
        if (range == null) {
            return Value.ZERO;
        }
        ScalarValue lowerBound = new ScalarValue((Double)range.r);
        ScalarValue upperBound = new ScalarValue((Double)range.s);
        if (value.greaterThan((Value)upperBound)) {
            return Value.ONE;
        }
        if (lowerBound.greaterThan(value)) {
            return Value.ONE;
        }
        return Value.ZERO;
    }
}

