/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.iteration.visitors.weights;

import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.visitors.weights.WeightVisitor;
import networks.structure.components.weights.StatefulWeight;
import networks.structure.components.weights.Weight;

public class WeightUpdater
implements WeightVisitor {
    private static final Logger LOG = Logger.getLogger(WeightUpdater.class.getName());
    public Value[] weightUpdates;
    private boolean[] active;

    public WeightUpdater(List<Weight> weights) {
        this.weightUpdates = new Value[weights.size()];
        this.active = new boolean[weights.size()];
        for (Weight weight : weights) {
            int index = weight.index;
            if (index >= this.weightUpdates.length) {
                LOG.severe("Weight index exceeding number of all extracted weights");
            }
            if (!weight.isLearnable()) continue;
            this.weightUpdates[index] = weight.value.getForm();
            if (this.active[index]) {
                LOG.severe("Weight index seen twice! Input weight list is not unique! Some weight will try to be updated twice!");
            }
            this.active[index] = true;
        }
    }

    @Override
    public void visit(Weight weight, Value value) {
        if (weight.isLearnable.booleanValue()) {
            int index = weight.index;
            this.weightUpdates[index].incrementBy(value);
        }
    }

    @Deprecated
    public void visit(StatefulWeight weight, Value value) {
        weight.getAccumulatedUpdate().incrementBy(value);
    }

    public void clearUpdates() {
        for (int i = 0; i < this.weightUpdates.length; ++i) {
            Value weightUpdate = this.weightUpdates[i];
            if (weightUpdate == null) continue;
            weightUpdate.zero();
        }
    }
}

