/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.training.optimizers;

import java.util.List;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.visitors.weights.WeightUpdater;
import networks.computation.training.NeuralModel;
import networks.computation.training.optimizers.Adam;
import networks.computation.training.optimizers.SGD;
import networks.structure.components.weights.Weight;
import settings.Settings;

public interface Optimizer {
    public static Optimizer getFrom(Settings settings, Value learningRate) {
        if (settings.optimizer == Settings.OptimizerSet.SGD) {
            return new SGD(learningRate);
        }
        if (settings.optimizer == Settings.OptimizerSet.ADAM) {
            return new Adam(learningRate);
        }
        return new SGD(learningRate);
    }

    public void performGradientStep(NeuralModel var1, WeightUpdater var2);

    public void performGradientStep(List<Weight> var1, Value[] var2);

    public void restart(Settings var1);
}

