/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.training.optimizers;

import java.util.List;
import java.util.logging.Logger;
import networks.computation.evaluation.values.Value;
import networks.computation.iteration.visitors.weights.WeightUpdater;
import networks.computation.training.NeuralModel;
import networks.computation.training.optimizers.Optimizer;
import networks.structure.components.weights.Weight;
import settings.Settings;

public class SGD
implements Optimizer {
    private static final Logger LOG = Logger.getLogger(SGD.class.getName());
    Value learningRate;

    public SGD(Value learningRate) {
        this.learningRate = learningRate;
    }

    @Override
    public void performGradientStep(NeuralModel neuralModel, WeightUpdater weightUpdater) {
        this.performGradientStep(neuralModel.weights, weightUpdater.weightUpdates);
    }

    @Override
    public void performGradientStep(List<Weight> weights, Value[] weightUpdates) {
        for (Weight weight : weights) {
            if (!weight.isLearnable.booleanValue()) continue;
            Value update = weightUpdates[weight.index];
            weight.value.incrementBy(update);
            LOG.finest("Incrementing " + weight + " with " + update);
        }
    }

    @Override
    public void restart(Settings settings) {
    }
}

