/*
 * Decompiled with CFR 0.152.
 */
package networks.computation.training.strategies.Hyperparameters;

import java.util.logging.Logger;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.metadata.states.State;
import networks.structure.metadata.states.States;
import settings.Settings;

public class DropoutRateStrategy {
    private static final Logger LOG = Logger.getLogger(DropoutRateStrategy.class.getName());
    private final Settings settings;

    public DropoutRateStrategy(Settings settings) {
        this.settings = settings;
    }

    public void setDropout(BaseNeuron neuron) {
        State.Neural.Computation.HasDropout hasDropout;
        State.Neural.Computation computationView = neuron.getComputationView(0);
        if (computationView instanceof State.Neural.Computation.HasDropout && (hasDropout = (State.Neural.Computation.HasDropout)((Object)computationView)).getDropoutRate(null) == 0.0) {
            if (neuron.getRawState() instanceof States.ComputationStateComposite) {
                LOG.severe("Dropout not yet set for a parallel state! You should setup the state first and THEN make it parallel.");
            }
            hasDropout.setDropoutRate(this.getDropoutRate(neuron.layer));
        }
    }

    private double getDropoutRate(int layer) {
        return this.settings.dropoutRate / (double)layer;
    }
}

