/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.building;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import constructs.example.ValuedFact;
import constructs.template.components.GroundHeadRule;
import constructs.template.components.GroundRule;
import ida.ilp.logic.Literal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.types.AggregationNeuron;
import networks.structure.components.neurons.types.AtomNeurons;
import networks.structure.components.neurons.types.FactNeuron;
import networks.structure.components.neurons.types.NegationNeuron;
import networks.structure.components.neurons.types.RuleNeurons;
import networks.structure.metadata.inputMappings.LinkedMapping;

public class NeuronMaps {
    @NotNull
    public LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>> groundRules;
    @NotNull
    public Map<Literal, ValuedFact> groundFacts;
    public Map<Literal, AtomNeurons> atomNeurons = new HashMap<Literal, AtomNeurons>();
    public Map<GroundHeadRule, AggregationNeuron> aggNeurons = new HashMap<GroundHeadRule, AggregationNeuron>();
    public Map<GroundRule, RuleNeurons> ruleNeurons = new LinkedHashMap<GroundRule, RuleNeurons>();
    public Map<Literal, FactNeuron> factNeurons = new HashMap<Literal, FactNeuron>();
    public Set<NegationNeuron> negationNeurons = new HashSet<NegationNeuron>();
    @Nullable
    public Map<Neurons, LinkedMapping> extraInputMapping = new HashMap<Neurons, LinkedMapping>();
    public boolean containsMasking;
    public boolean containsCrossproduct;

    public NeuronMaps(LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>> groundRules, Map<Literal, ValuedFact> groundFacts) {
        this.groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>>(groundRules);
        this.groundFacts = new HashMap<Literal, ValuedFact>(groundFacts);
    }

    public void addAllFrom(NeuronMaps neuronMaps) {
        this.atomNeurons.putAll(neuronMaps.atomNeurons);
        this.aggNeurons.putAll(neuronMaps.aggNeurons);
        this.ruleNeurons.putAll(neuronMaps.ruleNeurons);
        this.factNeurons.putAll(neuronMaps.factNeurons);
        this.extraInputMapping.putAll(neuronMaps.extraInputMapping);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nmaps: unused ground head literals: ").append(this.groundRules.size());
        sb.append(", unused groundFacts: ").append(this.groundFacts.size());
        sb.append(", atomNeurons: ").append(this.atomNeurons.size());
        sb.append(", aggNeurons: ").append(this.aggNeurons.size());
        sb.append(", ruleNeurons: ").append(this.ruleNeurons.size());
        sb.append(", factNeurons: ").append(this.factNeurons.size());
        sb.append(", negationNeurons: ").append(this.negationNeurons.size());
        return sb.toString();
    }
}

