/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.types.AggregationNeuron;
import networks.structure.components.neurons.types.AtomNeuron;
import networks.structure.components.neurons.types.AtomNeurons;
import networks.structure.components.neurons.types.FactNeuron;
import networks.structure.components.neurons.types.NegationNeuron;
import networks.structure.components.neurons.types.RuleNeuron;
import networks.structure.components.neurons.types.RuleNeurons;
import networks.structure.components.neurons.types.WeightedAtomNeuron;
import networks.structure.components.neurons.types.WeightedRuleNeuron;

public class NeuronSets {
    public List<AtomNeuron> atomNeurons = new ArrayList<AtomNeuron>();
    public List<WeightedAtomNeuron> weightedAtomNeurons = new ArrayList<WeightedAtomNeuron>();
    public List<AggregationNeuron> aggNeurons;
    public List<RuleNeuron> ruleNeurons;
    public List<WeightedRuleNeuron> weightedRuleNeurons;
    public List<FactNeuron> factNeurons;
    public List<NegationNeuron> negationNeurons;
    List<BaseNeuron> roots;
    List<BaseNeuron> leaves;

    public NeuronSets() {
        this.aggNeurons = new ArrayList<AggregationNeuron>();
        this.ruleNeurons = new ArrayList<RuleNeuron>();
        this.weightedRuleNeurons = new ArrayList<WeightedRuleNeuron>();
        this.factNeurons = new ArrayList<FactNeuron>();
        this.negationNeurons = new ArrayList<NegationNeuron>();
    }

    public NeuronSets(Collection<AtomNeurons> atomNeurons, Collection<AggregationNeuron> aggregationNeurons, Collection<RuleNeurons> ruleNeurons, Collection<FactNeuron> factNeurons, Collection<NegationNeuron> negationNeurons) {
        for (AtomNeurons atomNeuron : atomNeurons) {
            if (atomNeuron instanceof WeightedAtomNeuron) {
                this.weightedAtomNeurons.add((WeightedAtomNeuron)atomNeuron);
                continue;
            }
            this.atomNeurons.add((AtomNeuron)atomNeuron);
        }
        this.aggNeurons = new ArrayList<AggregationNeuron>(aggregationNeurons);
        this.ruleNeurons = new ArrayList<RuleNeuron>();
        this.weightedRuleNeurons = new ArrayList<WeightedRuleNeuron>();
        for (RuleNeurons ruleNeuron : ruleNeurons) {
            if (ruleNeuron instanceof WeightedRuleNeuron) {
                this.weightedRuleNeurons.add((WeightedRuleNeuron)ruleNeuron);
                continue;
            }
            this.ruleNeurons.add((RuleNeuron)ruleNeuron);
        }
        this.factNeurons = new ArrayList<FactNeuron>(factNeurons);
        this.negationNeurons = new ArrayList<NegationNeuron>(negationNeurons);
    }

    public List<Neurons> getAllNeurons() {
        ArrayList<Neurons> allNeurons = new ArrayList<Neurons>();
        allNeurons.addAll(this.atomNeurons);
        allNeurons.addAll(this.weightedAtomNeurons);
        allNeurons.addAll(this.ruleNeurons);
        allNeurons.addAll(this.weightedRuleNeurons);
        allNeurons.addAll(this.aggNeurons);
        allNeurons.addAll(this.factNeurons);
        allNeurons.addAll(this.negationNeurons);
        return allNeurons;
    }
}

