/*
 * Decompiled with CFR 0.152.
 */
package networks.structure.transforming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.BaseNeuron;
import networks.structure.components.neurons.Neurons;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.neurons.WeightedNeuron;
import networks.structure.components.types.DetailedNetwork;
import networks.structure.metadata.states.State;
import networks.structure.transforming.NetworkReducing;
import settings.Settings;
import utils.Timing;

public class LinearChainReducer
implements NetworkReducing {
    private static final Logger LOG = Logger.getLogger(LinearChainReducer.class.getName());
    private final transient Settings settings;
    int allNeurons = 0;
    int prunedNeurons = 0;
    Timing timing;

    public LinearChainReducer(Settings settings) {
        this.settings = settings;
        this.timing = new Timing();
    }

    @Override
    public NeuralNetwork reduce(DetailedNetwork<State.Structure> inet, List<QueryNeuron> outputs) {
        this.timing.tic();
        int sizeBefore = inet.allNeuronsTopologic.size();
        for (int i = sizeBefore - 1; i >= 0; --i) {
            BaseNeuron neuron = (BaseNeuron)inet.allNeuronsTopologic.get(i);
            if (!this.settings.pruneEvenWeightedNeurons && neuron instanceof WeightedNeuron) continue;
            this.prune(inet, neuron);
        }
        List<BaseNeuron<Neurons, State.Neural>> collect = outputs.stream().map(s -> (BaseNeuron)((Object)s.neuron)).collect(Collectors.toList());
        NetworkReducing.supervisedNetReconstruction(inet, collect);
        int sizeAfter = inet.allNeuronsTopologic.size();
        this.allNeurons += sizeBefore;
        this.prunedNeurons += sizeAfter;
        LOG.info("LinearChainPruning reduced neurons from " + sizeBefore + " down to " + sizeAfter);
        this.timing.toc();
        return inet;
    }

    @Override
    public NeuralNetwork reduce(DetailedNetwork<State.Structure> inet, QueryNeuron outputNeuron) {
        return this.reduce(inet, Arrays.asList(outputNeuron));
    }

    @Override
    public void finish() {
        this.timing.finish();
    }

    private void prune(DetailedNetwork<State.Structure> inet, BaseNeuron<Neurons, State.Neural> middle) {
        ArrayList middleInputNeurons = new ArrayList();
        Iterator<Neurons> inputs = inet.getInputs(middle);
        inputs.forEachRemaining(middleInputNeurons::add);
        if (middleInputNeurons.size() == 1) {
            BaseNeuron child = (BaseNeuron)middleInputNeurons.get(0);
            Iterator<Neurons> parents = inet.getOutputs(middle);
            if (parents == null) {
                LOG.warning("Neuron has only 1 input but has no output, thus not pruning it.");
                return;
            }
            parents.forEachRemaining(parent -> {
                inet.replaceInput((BaseNeuron)parent, middle, child);
                inet.replaceOutput(child, middle, (Neurons)parent);
            });
        }
    }

    private void prune(DetailedNetwork<State.Structure> inet, WeightedNeuron<Neurons, State.Neural> middle) {
        LOG.warning("Trying to prune weighted neuron input");
    }
}

