/*
 * Decompiled with CFR 0.152.
 */
package parsing.examples;

import com.sun.istack.internal.NotNull;
import constructs.Conjunction;
import constructs.example.LiftedExample;
import java.util.logging.Logger;
import java.util.stream.Stream;
import parsing.antlr.NeuralogicParser;
import parsing.examples.ExamplesParseTreeExtractor;
import parsing.grammarParsing.PlainGrammarVisitor;
import utils.Utilities;
import utils.generic.Pair;

public class PlainExamplesParseTreeExtractor
extends ExamplesParseTreeExtractor<PlainGrammarVisitor> {
    private static final Logger LOG = Logger.getLogger(PlainExamplesParseTreeExtractor.class.getName());

    public PlainExamplesParseTreeExtractor(PlainGrammarVisitor v) {
        super(v);
    }

    @Override
    public Stream<LiftedExample> getUnlabeledExamples(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        PlainGrammarVisitor.LiftedExampleVisitor liftedExampleVisitor = new PlainGrammarVisitor.LiftedExampleVisitor((PlainGrammarVisitor)this.visitor);
        if (ctx.liftedExample() != null) {
            Stream<LiftedExample> listStream = ctx.liftedExample().stream().map(rule -> rule.accept(liftedExampleVisitor));
            return listStream;
        }
        LOG.severe("Could not extract any Unlabeled trainExamples");
        return null;
    }

    @Override
    public Stream<Pair<Conjunction, LiftedExample>> getLabeledExamples(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        if (ctx.label() == null || ctx.label().isEmpty()) {
            return this.getUnlabeledExamples(ctx).map(ex -> new Pair<Object, LiftedExample>(null, (LiftedExample)ex));
        }
        return Utilities.zipStreams(this.getQueries(ctx), this.getUnlabeledExamples(ctx), (q, e) -> this.createSamplePair((Conjunction)q, (LiftedExample)e));
    }

    private Pair<Conjunction, LiftedExample> createSamplePair(Conjunction q, LiftedExample e) {
        LOG.finer("Merging query/label " + q.toString() + " with example " + e);
        return new Pair<Conjunction, LiftedExample>(q, e);
    }

    @Override
    public Stream<Conjunction> getQueries(@NotNull NeuralogicParser.ExamplesFileContext ctx) {
        PlainGrammarVisitor.LabelVisitor labelVisitor = new PlainGrammarVisitor.LabelVisitor((PlainGrammarVisitor)this.visitor);
        if (ctx.label() != null && !ctx.label().isEmpty()) {
            return ctx.label().stream().map(line -> line.accept(labelVisitor));
        }
        LOG.severe("Could not extract any trainQueries (weighted facts)");
        return null;
    }
}

