/*
 * Decompiled with CFR 0.152.
 */
package parsing.template;

import com.sun.istack.internal.NotNull;
import constructs.Conjunction;
import constructs.WeightedPredicate;
import constructs.example.ValuedFact;
import constructs.template.components.WeightedRule;
import constructs.template.metadata.Metadata;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import networks.structure.components.weights.Weight;
import parsing.antlr.NeuralogicBaseVisitor;
import parsing.antlr.NeuralogicParser;
import parsing.grammarParsing.PlainGrammarVisitor;
import parsing.template.TemplateParseTreeExtractor;
import utils.generic.Pair;

public class PlainTemplateParseTreeExtractor
extends TemplateParseTreeExtractor<PlainGrammarVisitor> {
    private static final Logger LOG = Logger.getLogger(PlainTemplateParseTreeExtractor.class.getName());

    public PlainTemplateParseTreeExtractor(PlainGrammarVisitor visitor) {
        super(visitor);
    }

    @Override
    public List<WeightedRule> getWeightedRules(@NotNull NeuralogicParser.TemplateFileContext ctx) {
        return new RuleLinesVisitor().visitTemplateFile(ctx);
    }

    @Override
    public List<ValuedFact> getWeightedFacts(@NotNull NeuralogicParser.TemplateFileContext ctx) {
        return new FactsVisitor().visitTemplateFile(ctx);
    }

    @Override
    public List<Conjunction> getWeightedConjunctions(NeuralogicParser.TemplateFileContext ctx) {
        return new ConjunctionsVisitor().visitTemplateFile(ctx);
    }

    @Override
    public List<Pair<Weight, Map<String, Object>>> getWeightsMetadata(@NotNull NeuralogicParser.TemplateFileContext ctx) {
        return new WeightsMetadataVisitor().visitTemplateFile(ctx);
    }

    @Override
    public List<Pair<WeightedPredicate, Map<String, Object>>> getPredicatesMetadata(@NotNull NeuralogicParser.TemplateFileContext ctx) {
        return new PredicatesMetadataVisitor().visitTemplateFile(ctx);
    }

    @Override
    public Map<String, Object> getTemplateMetadata(NeuralogicParser.TemplateFileContext ctx) {
        return null;
    }

    public class TemplateMetadataVisitor
    extends NeuralogicBaseVisitor<Map<String, Object>> {
        @Override
        public Map<String, Object> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.TemplateMetadataVisitor templateMetadataVisitor = new PlainGrammarVisitor.TemplateMetadataVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            Map<String, Object> metadata = template_lines.stream().filter(line -> line.templateMetadata() != null).map(line -> line.templateMetadata().accept(templateMetadataVisitor)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, null));
            return metadata;
        }
    }

    public class PredicatesMetadataVisitor
    extends NeuralogicBaseVisitor<List<Pair<WeightedPredicate, Map<String, Object>>>> {
        @Override
        public List<Pair<WeightedPredicate, Map<String, Object>>> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.PredicateOffsetVisitor predicateOffsetVisitor = new PlainGrammarVisitor.PredicateOffsetVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            template_lines.stream().filter(line -> line.predicateOffset() != null).map(line -> line.predicateOffset().accept(predicateOffsetVisitor)).collect(Collectors.toList());
            PlainGrammarVisitor.PredicateMetadataVisitor predicateMetadataVisitor = new PlainGrammarVisitor.PredicateMetadataVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            List<Pair<WeightedPredicate, Map<String, Object>>> predicateMetadataList = template_lines.stream().filter(line -> line.predicateMetadata() != null).map(line -> line.predicateMetadata().accept(predicateMetadataVisitor)).collect(Collectors.toMap(pair -> (WeightedPredicate)pair.r, pair -> (Map)pair.s, Metadata::merge)).entrySet().stream().map(entry -> new Pair(entry.getKey(), entry.getValue())).collect(Collectors.toList());
            return predicateMetadataList;
        }
    }

    public class WeightsMetadataVisitor
    extends NeuralogicBaseVisitor<List<Pair<Weight, Map<String, Object>>>> {
        @Override
        public List<Pair<Weight, Map<String, Object>>> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.WeightMetadataVisitor weightMetadataVisitor = new PlainGrammarVisitor.WeightMetadataVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            List<Pair<Weight, Map<String, Object>>> weightMetadataList = template_lines.stream().filter(line -> line.weightMetadata() != null).map(line -> line.lrnnRule().accept(weightMetadataVisitor)).collect(Collectors.toMap(pair -> (Weight)pair.r, pair -> (Map)pair.s, Metadata::merge)).entrySet().stream().map(entry -> new Pair(entry.getKey(), entry.getValue())).collect(Collectors.toList());
            return weightMetadataList;
        }
    }

    public class ConjunctionsVisitor
    extends NeuralogicBaseVisitor<List<Conjunction>> {
        @Override
        public List<Conjunction> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.FactConjunctionVisitor factConjunctionVisitor = new PlainGrammarVisitor.FactConjunctionVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            List<Conjunction> conjunctions = template_lines.stream().filter(line -> line.conjunction() != null).map(line -> line.conjunction().accept(factConjunctionVisitor)).collect(Collectors.toList());
            return conjunctions;
        }
    }

    public class FactsVisitor
    extends NeuralogicBaseVisitor<List<ValuedFact>> {
        @Override
        public List<ValuedFact> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.FactVisitor factVisitor = new PlainGrammarVisitor.FactVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            List<ValuedFact> facts = template_lines.stream().filter(line -> line.fact() != null).map(line -> line.fact().accept(factVisitor)).collect(Collectors.toList());
            return facts;
        }
    }

    public class RuleLinesVisitor
    extends NeuralogicBaseVisitor<List<WeightedRule>> {
        @Override
        public List<WeightedRule> visitTemplateFile(@NotNull NeuralogicParser.TemplateFileContext ctx) {
            List<NeuralogicParser.TemplateLineContext> template_lines = ctx.templateLine();
            PlainGrammarVisitor.RuleLineVisitor ruleLineVisitor = new PlainGrammarVisitor.RuleLineVisitor((PlainGrammarVisitor)PlainTemplateParseTreeExtractor.this.visitor);
            List<WeightedRule> rules = template_lines.stream().filter(line -> line.lrnnRule() != null).map(line -> line.lrnnRule().accept(ruleLineVisitor)).collect(Collectors.toList());
            return rules;
        }
    }
}

