/*
 * Decompiled with CFR 0.152.
 */
package pipelines;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Logger;
import pipelines.Block;
import pipelines.Branch;
import pipelines.ConnectAfter;
import pipelines.ConnectBefore;
import pipelines.Merge;
import pipelines.MultiBranch;
import pipelines.MultiMerge;
import pipelines.ParallelPipe;
import pipelines.Pipe;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.debug.PipelineDebugger;
import settings.Settings;
import settings.Sources;
import utils.exporting.Exporter;
import utils.generic.Pair;

public class Pipeline<S, T>
extends Block
implements ConnectBefore<S>,
ConnectAfter<T>,
Function<S, T> {
    private static final Logger LOG = Logger.getLogger(Pipeline.class.getName());
    public AbstractPipelineBuilder<S, T> originalBuilder;
    public ConnectBefore<S> start;
    public ConnectAfter<T> terminal;
    public ConcurrentHashMap<String, Branch> branches = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Merge> merges = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Pipe> pipes = new ConcurrentHashMap();
    @Deprecated
    public ConcurrentHashMap<String, ParallelPipe> multiPipes = new ConcurrentHashMap();
    public ConcurrentHashMap<String, MultiBranch> multiBranches = new ConcurrentHashMap();
    public ConcurrentHashMap<String, MultiMerge> multiMerges = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Pipeline> pipelines = new ConcurrentHashMap();
    public ConnectAfter<S> input;
    public ConnectBefore<T> output;
    private boolean invalidated = false;

    public static Pipeline<Sources, ?> getPipeline(Settings settings, Sources sources) {
        LOG.finest("Building pipeline from sources and settings...");
        AbstractPipelineBuilder<Sources, ?> pipelineBuilder = AbstractPipelineBuilder.getBuilder(sources, settings);
        Pipeline<Sources, ?> pipeline = pipelineBuilder.buildPipeline();
        if (settings.debugPipeline) {
            super.debug();
        }
        LOG.finest("The main pipeline has been built");
        return pipeline;
    }

    private void debug() {
        new PipelineDebugger(this.settings).debug(this);
    }

    private Pipeline(String id) {
        this.ID = id;
    }

    public Pipeline(String id, AbstractPipelineBuilder<S, T> originalBuilder) {
        this(id, originalBuilder.settings);
        this.originalBuilder = originalBuilder;
    }

    public Pipeline(String id, Settings settings) {
        this(id, settings, Exporter.getFrom(id, settings));
    }

    public Pipeline(String id, Settings settings, Exporter exporter) {
        this.ID = id;
        this.settings = settings;
        this.exporter = exporter;
    }

    public Pair<String, T> execute(S source) {
        LOG.info("Executing pipeline : " + this.ID);
        this.start.accept(source);
        return new Pair(this.ID, this.terminal.get());
    }

    public <I, O, A extends Pipe<I, O>> A register(A p) {
        this.pipes.put(p.ID, p);
        p.parent = this;
        return p;
    }

    @Deprecated
    public <I, O, A extends ParallelPipe<I, O>> A register(A m) {
        this.multiPipes.put(m.ID, m);
        return m;
    }

    public <I, O1, O2, A extends Branch<I, O1, O2>> A register(A b) {
        this.branches.put(b.ID, b);
        this.register((A)((Object)b.output1));
        this.register((A)((Object)b.output2));
        b.parent = this;
        return b;
    }

    public <I1, I2, O, A extends Merge<I1, I2, O>> A register(A m) {
        this.merges.put(m.ID, m);
        this.register((A)((Object)m.input1));
        this.register((A)((Object)m.input2));
        m.parent = this;
        return m;
    }

    public <I, O> Pipeline<I, O> register(Pipeline<I, O> p) {
        this.pipelines.put(p.ID, p);
        p.parent = this;
        return p;
    }

    public <I, O, A extends MultiBranch<I, O>> A register(A m) {
        this.multiBranches.put(m.ID, m);
        m.parent = this;
        return m;
    }

    public <I, O, A extends MultiMerge<I, O>> A register(A m) {
        this.multiMerges.put(m.ID, m);
        m.parent = this;
        return m;
    }

    public <O, A extends Pipe<S, O>> A registerStart(A p) {
        this.start = p;
        this.register(p);
        return p;
    }

    public <O1, O2, A extends Branch<S, O1, O2>> A registerStart(A p) {
        this.start = p;
        this.register(p);
        return p;
    }

    public <O, A extends MultiBranch<S, O>> A registerStart(A m) {
        this.start = m;
        this.register(m);
        return m;
    }

    public <O, A extends Pipeline<S, O>> A registerStart(A p) {
        this.start = p;
        this.register(p);
        return p;
    }

    public <I, A extends Pipe<I, T>> A registerEnd(A p) {
        this.terminal = p;
        this.register(p);
        return p;
    }

    public <I1, I2, A extends Merge<I1, I2, T>> A registerEnd(A p) {
        this.terminal = p;
        this.register(p);
        return p;
    }

    public <I, A extends MultiMerge<I, T>> A registerEnd(A p) {
        this.terminal = p;
        this.register(p);
        return p;
    }

    public <I, A extends Pipeline<I, T>> A registerEnd(A p) {
        this.terminal = p.terminal;
        this.register(p);
        return p;
    }

    public <U> Pipeline<S, U> mergeAfter(Pipeline<T, U> next) {
        Pipeline<S, T> pipeline = new Pipeline<S, T>(this.ID + "+" + next.ID);
        pipeline.start = this.start;
        pipeline.terminal = next.terminal;
        pipeline.settings = this.settings;
        pipeline.input = this.input;
        pipeline.output = next.output;
        pipeline.pipelines.put(this.ID, this);
        pipeline.pipelines.put(next.ID, next);
        return pipeline;
    }

    @Override
    public void accept(S sources) {
        LOG.finer("Entering pipeline: " + this.ID);
        if (this.invalidated) {
            this.rebuild(this.settings);
        }
        this.start.accept(sources);
        super.export(this.terminal.get());
        if (this.output != null) {
            this.output.accept(this.terminal.get());
        }
    }

    public void rebuild(Settings settings) {
        LOG.info("Rebuilding pipeline " + this.ID);
        Pipeline<S, T> pipeline = this.originalBuilder.buildPipeline();
        if (!this.start.toString().equals(pipeline.start.toString())) {
            LOG.warning("Pipeline start changed after rebuild from " + this.start.toString() + " to " + pipeline.start.toString());
            if (this.parent.start == this.start) {
                this.parent.start = pipeline.start;
            }
        }
        if (!this.terminal.toString().equals(pipeline.terminal.toString())) {
            LOG.warning("Pipeline terminal changed after rebuild from " + this.terminal.toString() + " to " + pipeline.terminal.toString());
            if (this.parent.terminal == this.terminal) {
                this.parent.terminal = pipeline.terminal;
            }
        }
        pipeline.start.setInput(this.start.getInput());
        pipeline.terminal.setOutput(this.terminal.getOutput());
        this.copyFrom(pipeline);
    }

    private void copyFrom(Pipeline<S, T> pipeline) {
        this.start = pipeline.start;
        this.terminal = pipeline.terminal;
        this.branches = pipeline.branches;
        this.merges = pipeline.merges;
        this.pipes = pipeline.pipes;
        this.multiBranches = pipeline.multiBranches;
        this.multiMerges = pipeline.multiMerges;
        this.pipelines = pipeline.pipelines;
    }

    @Override
    public T get() {
        return this.terminal.get();
    }

    @Override
    public ConnectBefore<T> getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(ConnectBefore<T> prev) {
        this.output = prev;
    }

    @Override
    public ConnectAfter<S> getInput() {
        return this.input;
    }

    @Override
    public void setInput(ConnectAfter<S> prev) {
        this.input = prev;
    }

    @Override
    public T apply(S s) {
        return (T)this.execute(s).s;
    }

    public Pipeline findPipeline(String id) {
        if (this.ID.equals(id)) {
            return this;
        }
        Pipeline pipeline = this.pipelines.get(id);
        if (pipeline != null) {
            return pipeline;
        }
        for (Pipeline value : this.pipelines.values()) {
            Pipeline inner = value.findPipeline(id);
            if (inner == null) continue;
            return inner;
        }
        return null;
    }
}

